/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Map;
import javax.management.ObjectName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.hive.ql.exec.repl.NoOpReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.FailoverMetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricSink;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.hadoop.metrics2.util.MBeans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicationMetricCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationMetricCollector.class);
    private ReplicationMetric replicationMetric;
    private MetricCollector metricCollector;
    private boolean isEnabled;
    private static boolean enableForTests;
    private static long scheduledExecutionIdForTests;
    private HiveConf conf;
    private ObjectName metricsMBean;
    private AtomicDouble sizeOfDataReplicatedInKB = new AtomicDouble(0.0);

    public void setMetricsMBean(ObjectName metricsMBean) {
        this.metricsMBean = metricsMBean;
    }

    public ReplicationMetricCollector(String dbName, Metadata.ReplicationType replicationType, String stagingDir, long dumpExecutionId, HiveConf conf) {
        this.conf = conf;
        this.checkEnabledForTests(conf);
        String policy = conf.get("scheduled.query.schedulename");
        long executionId = conf.getLong("scheduled.query.executionid", 0L);
        if (!StringUtils.isEmpty((CharSequence)policy) && executionId > 0L) {
            this.isEnabled = true;
            this.metricCollector = MetricCollector.getInstance().init(conf);
            MetricSink.getInstance().init(conf);
            Metadata metadata = new Metadata(dbName, replicationType, this.getStagingDir(stagingDir));
            this.replicationMetric = new ReplicationMetric(executionId, policy, dumpExecutionId, metadata);
        }
    }

    public ReplicationMetricCollector(String dbName, Metadata.ReplicationType replicationType, String stagingDir, long dumpExecutionId, HiveConf conf, String failoverEndpoint, String failoverType) {
        this.conf = conf;
        this.checkEnabledForTests(conf);
        String policy = conf.get("scheduled.query.schedulename");
        long executionId = conf.getLong("scheduled.query.executionid", 0L);
        if (!StringUtils.isEmpty((CharSequence)policy) && executionId > 0L) {
            this.isEnabled = true;
            this.metricCollector = MetricCollector.getInstance().init(conf);
            MetricSink.getInstance().init(conf);
            Metadata metadata = new Metadata(dbName, replicationType, this.getStagingDir(stagingDir));
            metadata.setFailoverEndPoint(failoverEndpoint);
            metadata.setFailoverType(failoverType);
            this.replicationMetric = new ReplicationMetric(executionId, policy, dumpExecutionId, metadata);
        }
    }

    public void incrementSizeOfDataReplicated(long bytesCount) {
        this.sizeOfDataReplicatedInKB.addAndGet((double)bytesCount / 1024.0);
    }

    public void reportStageStart(String stageName, Map<String, Long> metricMap) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage Started {}, {}, {}", new Object[]{stageName, metricMap.size(), metricMap});
            Progress progress = this.replicationMetric.getProgress();
            progress.setStatus(Status.IN_PROGRESS);
            Stage stage = new Stage(stageName, Status.IN_PROGRESS, this.getCurrentTimeInMillis());
            for (Map.Entry<String, Long> metric : metricMap.entrySet()) {
                stage.addMetric(new Metric(metric.getKey(), metric.getValue()));
            }
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    public void reportFailoverStart(String stageName, Map<String, Long> metricMap, FailoverMetaData failoverMd, String failoverEndpoint, String failoverType) throws SemanticException {
        if (this.isEnabled) {
            LOG.info("Failover Stage Started {}, {}, {}", new Object[]{stageName, metricMap.size(), metricMap});
            Progress progress = this.replicationMetric.getProgress();
            progress.setStatus(Status.FAILOVER_IN_PROGRESS);
            Stage stage = new Stage(stageName, Status.IN_PROGRESS, this.getCurrentTimeInMillis());
            for (Map.Entry<String, Long> metric : metricMap.entrySet()) {
                stage.addMetric(new Metric(metric.getKey(), metric.getValue()));
            }
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            Metadata metadata = this.replicationMetric.getMetadata();
            metadata.setFailoverMetadataLoc(failoverMd.getFilePath());
            metadata.setFailoverEventId(failoverMd.getFailoverEventId());
            metadata.setFailoverEndPoint(failoverEndpoint);
            metadata.setFailoverType(failoverType);
            this.replicationMetric.setMetadata(metadata);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    public void reportStageEnd(String stageName, Status status, long lastReplId, SnapshotUtils.ReplSnapshotCount replSnapshotCount, ReplStatsTracker replStatsTracker) throws SemanticException {
        this.unRegisterMBeanSafe();
        if (this.isEnabled) {
            LOG.debug("Stage ended {}, {}, {}", new Object[]{stageName, status, lastReplId});
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(this.getCurrentTimeInMillis());
            stage.setReplSnapshotsCount(replSnapshotCount);
            if (replStatsTracker != null && !(replStatsTracker instanceof NoOpReplStatsTracker)) {
                String replStatString = replStatsTracker.toString();
                LOG.info("Replication Statistics are: {}", (Object)replStatString);
                stage.setReplStats(replStatString);
            }
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            Metadata metadata = this.replicationMetric.getMetadata();
            metadata.setLastReplId(lastReplId);
            metadata.setReplicatedDBSizeInKB(this.sizeOfDataReplicatedInKB.get());
            this.replicationMetric.setMetadata(metadata);
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageEnd(String stageName, Status status, String errorLogPath) throws SemanticException {
        this.unRegisterMBeanSafe();
        if (this.isEnabled) {
            LOG.debug("Stage Ended {}, {}", (Object)stageName, (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(this.getCurrentTimeInMillis());
            if (errorLogPath != null) {
                stage.setErrorLogPath(errorLogPath);
            }
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status || Status.SKIPPED == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageEnd(String stageName, Status status) throws SemanticException {
        this.unRegisterMBeanSafe();
        if (this.isEnabled) {
            LOG.debug("Stage Ended {}, {}", (Object)stageName, (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            if (stage == null) {
                stage = new Stage(stageName, status, -1L);
            }
            stage.setStatus(status);
            stage.setEndTime(this.getCurrentTimeInMillis());
            progress.addStage(stage);
            this.replicationMetric.setProgress(progress);
            Metadata metadata = this.replicationMetric.getMetadata();
            metadata.setReplicatedDBSizeInKB(this.sizeOfDataReplicatedInKB.get());
            this.metricCollector.addMetric(this.replicationMetric);
            if (Status.FAILED == status || Status.FAILED_ADMIN == status) {
                this.reportEnd(status);
            }
        }
    }

    public void reportStageProgress(String stageName, String metricName, long count) throws SemanticException {
        if (this.isEnabled) {
            LOG.debug("Stage progress {}, {}, {}", new Object[]{stageName, metricName, count});
            Progress progress = this.replicationMetric.getProgress();
            Stage stage = progress.getStageByName(stageName);
            Metric metric = stage.getMetricByName(metricName);
            metric.setCurrentCount(metric.getCurrentCount() + count);
            if (metric.getCurrentCount() > metric.getTotalCount()) {
                metric.setTotalCount(metric.getCurrentCount());
            }
            stage.addMetric(metric);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    public void reportEnd(Status status) throws SemanticException {
        if (this.isEnabled) {
            LOG.info("End {}", (Object)status);
            Progress progress = this.replicationMetric.getProgress();
            progress.setStatus(status);
            this.replicationMetric.setProgress(progress);
            this.metricCollector.addMetric(this.replicationMetric);
        }
    }

    @VisibleForTesting
    public static void isMetricsEnabledForTests(boolean enable) {
        enableForTests = enable;
    }

    private void checkEnabledForTests(HiveConf conf) {
        if (enableForTests) {
            conf.set("scheduled.query.schedulename", "pol");
            conf.setLong("scheduled.query.executionid", ++scheduledExecutionIdForTests);
        }
    }

    private void unRegisterMBeanSafe() {
        if (this.metricsMBean != null && !ReplLoadWork.disableMbeanUnregistrationForTests) {
            try {
                MBeans.unregister((ObjectName)this.metricsMBean);
            }
            catch (Exception e) {
                LOG.warn("Unable to unregister MBean {}", (Object)this.metricsMBean, (Object)e);
            }
        }
    }

    private boolean testingModeEnabled() {
        return this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL);
    }

    private long getCurrentTimeInMillis() {
        return this.testingModeEnabled() ? 0L : System.currentTimeMillis();
    }

    private String getStagingDir(String stagingDir) {
        return this.testingModeEnabled() ? "dummyDir" : stagingDir;
    }

    static {
        scheduledExecutionIdForTests = 0L;
    }
}

