/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.Compactor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorPipeline;
import org.apache.hadoop.hive.ql.txn.compactor.MRCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MergeCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.RebalanceQueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompactorFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactorFactory.class.getName());
    private static final String ICEBERG_QUERY_COMPACTOR_CLASS = "org.apache.iceberg.mr.hive.compaction.IcebergQueryCompactor";
    private static final CompactorFactory INSTANCE = new CompactorFactory();

    static CompactorFactory getInstance() {
        return INSTANCE;
    }

    private CompactorFactory() {
    }

    public CompactorPipeline getCompactorPipeline(Table table, HiveConf configuration, CompactionInfo compactionInfo, IMetaStoreClient msc) throws HiveException {
        if (AcidUtils.isFullAcidTable(table.getParameters())) {
            if (!"tez".equalsIgnoreCase(HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE)) || !HiveConf.getBoolVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED)) {
                if (CompactionType.REBALANCE.equals((Object)compactionInfo.type)) {
                    throw new HiveException("Rebalancing compaction is only supported in Tez, and via Query based compaction. Set hive.execution.engine=tez and hive.compactor.crud.query.based=true to enable it.");
                }
                if (!"tez".equalsIgnoreCase(HiveConf.getVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE)) && HiveConf.getBoolVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED)) {
                    LOG.warn("Query-based compaction is enabled, but it is only supported on tez. Falling back to MR compaction.");
                }
                return new CompactorPipeline(new MRCompactor(msc));
            }
            switch (compactionInfo.type) {
                case MINOR: {
                    return new CompactorPipeline(new MergeCompactor()).addCompactor(new MinorQueryCompactor());
                }
                case MAJOR: {
                    return new CompactorPipeline(new MergeCompactor()).addCompactor(new MajorQueryCompactor());
                }
                case REBALANCE: {
                    return new CompactorPipeline(new RebalanceQueryCompactor());
                }
            }
        } else {
            if (AcidUtils.isInsertOnlyTable(table.getParameters())) {
                if (!configuration.getBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM)) {
                    throw new HiveException("Insert only compaction is disabled. Set hive.compactor.compact.insert.only=true to enable it.");
                }
                switch (compactionInfo.type) {
                    case MINOR: {
                        return new CompactorPipeline(new MergeCompactor()).addCompactor(new MmMinorQueryCompactor());
                    }
                    case MAJOR: {
                        return new CompactorPipeline(new MergeCompactor()).addCompactor(new MmMajorQueryCompactor());
                    }
                }
                throw new HiveException(compactionInfo.type.name() + " compaction is not supported on insert only tables.");
            }
            if (MetaStoreUtils.isIcebergTable((Map)table.getParameters())) {
                switch (compactionInfo.type) {
                    case MINOR: 
                    case MAJOR: {
                        try {
                            Class<?> icebergMajorQueryCompactor = Class.forName(ICEBERG_QUERY_COMPACTOR_CLASS, true, Utilities.getSessionSpecifiedClassLoader());
                            return new CompactorPipeline((Compactor)icebergMajorQueryCompactor.newInstance());
                        }
                        catch (Exception e) {
                            throw new HiveException("Failed instantiating and calling Iceberg compactor");
                        }
                    }
                }
                throw new HiveException(compactionInfo.type.name() + " compaction is not supported on Iceberg tables.");
            }
        }
        throw new HiveException("Only transactional tables can be compacted, " + table.getTableName() + "is not suitable for compaction!");
    }
}

