/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderFactory;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MmMajorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)MmMajorQueryCompactor.class.getName());

    MmMajorQueryCompactor() {
    }

    @Override
    public boolean run(CompactorContext context) throws IOException {
        HiveConf hiveConf = context.getConf();
        Table table = context.getTable();
        LOG.debug("Going to delete directories for aborted transactions for MM table " + table.getDbName() + "." + table.getTableName());
        QueryCompactor.Util.removeFilesForMmTable(hiveConf, context.getAcidDirectory());
        StorageDescriptor storageDescriptor = context.getSd();
        ValidWriteIdList writeIds = context.getValidWriteIdList();
        HiveConf driverConf = this.setUpDriverSession(hiveConf);
        String tmpTableName = this.getTempTableName(table);
        Path resultBaseDir = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, driverConf, true, true, false, null);
        List<String> createTableQueries = this.getCreateQueries(tmpTableName, table, storageDescriptor, resultBaseDir.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, context.getPartition(), tmpTableName);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(driverConf, tmpTableName, context.getCompactionInfo(), Lists.newArrayList((Object[])new Path[]{resultBaseDir}), createTableQueries, compactionQueries, dropQueries, table.getParameters());
        return true;
    }

    @Override
    protected void commitCompaction(String tmpTableName, HiveConf conf) throws IOException, HiveException {
        QueryCompactor.Util.cleanupEmptyTableDir(conf, tmpTableName);
    }

    private List<String> getCreateQueries(String tmpTableName, Table table, StorageDescriptor storageDescriptor, String baseLocation) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, true).setOperation(CompactionQueryBuilder.Operation.CREATE).setResultTableName(tmpTableName).setStorageDescriptor(storageDescriptor).setSourceTab(table).setLocation(baseLocation).build()});
    }

    private List<String> getCompactionQueries(Table t, Partition p, String tmpName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, true).setOperation(CompactionQueryBuilder.Operation.INSERT).setResultTableName(tmpName).setSourceTab(t).setSourcePartition(p).build()});
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList((Object[])new String[]{new CompactionQueryBuilderFactory().getCompactionQueryBuilder(CompactionType.MAJOR, true).setOperation(CompactionQueryBuilder.Operation.DROP).setResultTableName(tmpTableName).build()});
    }
}

