/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnProjectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnProjectionUtils.class);
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";
    public static final String READ_NESTED_COLUMN_PATH_CONF_STR = "hive.io.file.readNestedColumn.paths";
    public static final String READ_ALL_COLUMNS = "hive.io.file.read.all.columns";
    public static final String READ_COLUMN_NAMES_CONF_STR = "hive.io.file.readcolumn.names";
    public static final String FETCH_VIRTUAL_COLUMNS_CONF_STR = "hive.io.file.fetch.virtual.columns";
    private static final String READ_COLUMN_IDS_CONF_STR_DEFAULT = "";
    private static final String READ_NESTED_COLUMN_PATH_CONF_STR_DEFAULT = "";
    private static final boolean READ_ALL_COLUMNS_DEFAULT = true;
    private static final Joiner CSV_JOINER = Joiner.on((String)",").skipNulls();
    public static final String ORC_SCHEMA_STRING = "hive.orc.schema.string";

    @Deprecated
    public static void setFullyReadColumns(Configuration conf) {
        ColumnProjectionUtils.setReadAllColumns(conf);
    }

    @Deprecated
    @VisibleForTesting
    public static void setReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    @Deprecated
    public static void appendReadColumnIDs(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void setReadAllColumns(Configuration conf) {
        conf.setBoolean(READ_ALL_COLUMNS, true);
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
    }

    public static boolean isReadAllColumns(Configuration conf) {
        return conf.getBoolean(READ_ALL_COLUMNS, true);
    }

    public static void setReadColumns(Configuration conf, List<Integer> ids) {
        ColumnProjectionUtils.setReadColumnIDConf(conf, "");
        ColumnProjectionUtils.appendReadColumns(conf, ids);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids) {
        String id = ColumnProjectionUtils.toReadColumnIDString(ids);
        String old = conf.get(READ_COLUMN_IDS_CONF_STR, null);
        String newConfStr = HiveStringUtils.joinIgnoringEmpty((String[])new String[]{id, old}, (char)',');
        ColumnProjectionUtils.setReadColumnIDConf(conf, newConfStr);
        conf.setBoolean(READ_ALL_COLUMNS, false);
    }

    public static void appendNestedColumnPaths(Configuration conf, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        String pathsStr = StringUtils.join((CharSequence)",", (String[])paths.toArray(new String[paths.size()]));
        String old = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, null);
        Object newConfStr = pathsStr;
        if (old != null && !old.isEmpty()) {
            newConfStr = (String)newConfStr + "," + old;
        }
        ColumnProjectionUtils.setReadNestedColumnPathConf(conf, (String)newConfStr);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids, List<String> names, List<String> groupPaths, boolean fetchVirtualCols) {
        if (ids.size() != names.size()) {
            LOG.warn("Read column counts do not match: " + ids.size() + " ids, " + names.size() + " names");
        }
        ColumnProjectionUtils.appendReadColumns(conf, ids);
        ColumnProjectionUtils.appendReadColumnNames(conf, names);
        ColumnProjectionUtils.appendNestedColumnPaths(conf, groupPaths);
        conf.setBoolean(FETCH_VIRTUAL_COLUMNS_CONF_STR, fetchVirtualCols);
    }

    public static void appendReadColumns(StringBuilder readColumnsBuffer, StringBuilder readColumnNamesBuffer, List<Integer> ids, List<String> names) {
        CSV_JOINER.appendTo(readColumnsBuffer, ids);
        CSV_JOINER.appendTo(readColumnNamesBuffer, names);
    }

    public static List<Integer> getReadColumnIDs(Configuration conf) {
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, "");
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static Set<String> getNestedColumnPaths(Configuration conf) {
        String skips = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)skips)));
    }

    public static String[] getReadColumnNames(Configuration conf) {
        String colNames = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        if (colNames != null && !colNames.isEmpty()) {
            return colNames.split(conf.get("column.name.delimiter", String.valueOf(',')));
        }
        return new String[0];
    }

    private static void setReadColumnIDConf(Configuration conf, String id) {
        if (id.trim().isEmpty()) {
            conf.set(READ_COLUMN_IDS_CONF_STR, "");
        } else {
            conf.set(READ_COLUMN_IDS_CONF_STR, id);
        }
    }

    private static void setReadNestedColumnPathConf(Configuration conf, String nestedColumnPaths) {
        if ((nestedColumnPaths = nestedColumnPaths.toLowerCase()).trim().isEmpty()) {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        } else {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, nestedColumnPaths);
        }
    }

    private static void appendReadColumnNames(Configuration conf, List<String> cols) {
        String old = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        String delim = conf.get("column.name.delimiter", String.valueOf(','));
        Object result = String.join((CharSequence)delim, cols);
        if (!old.isEmpty()) {
            result = old + delim + (String)result;
        }
        conf.set(READ_COLUMN_NAMES_CONF_STR, (String)result);
    }

    private static String toReadColumnIDString(List<Integer> ids) {
        Object id = "";
        for (int i = 0; i < ids.size(); ++i) {
            id = i == 0 ? (String)id + ids.get(i) : (String)id + "," + ids.get(i);
        }
        return id;
    }

    private ColumnProjectionUtils() {
    }
}

