/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.discriminator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.discriminator.DiscriminatorDefiner;
import org.datanucleus.store.rdbms.mapping.java.DiscriminatorMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;

public class DiscriminatorUtils {
    public static BooleanExpression getExpressionForDiscriminatorForClass(SQLStatement stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, SQLTable discrimSqlTbl, ClassLoaderResolver clr) {
        BooleanExpression customExpr;
        DiscriminatorDefiner discriminatorDefiner = stmt.getRDBMSManager().getDiscriminatorDefiner(discriminatorMapping.getTable().getClassMetaData(), clr);
        BooleanExpression booleanExpression = customExpr = discriminatorDefiner != null ? discriminatorDefiner.getExpressionForDiscriminatorForClass(stmt, className, dismd, discriminatorMapping, discrimSqlTbl, clr) : null;
        if (customExpr != null) {
            return customExpr;
        }
        Object discriminatorValue = DiscriminatorUtils.getDiscriminatorValueForClass((NucleusContext)stmt.getRDBMSManager().getNucleusContext(), className, dismd, discriminatorMapping, clr);
        SQLExpression discrExpr = stmt.getSQLExpressionFactory().newExpression(stmt, discrimSqlTbl, discriminatorMapping);
        SQLExpression discrVal = stmt.getSQLExpressionFactory().newLiteral(stmt, discriminatorMapping, discriminatorValue);
        return discrExpr.eq(discrVal);
    }

    public static Object getDiscriminatorValueForClass(NucleusContext nucleusCtx, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, ClassLoaderResolver clr) {
        AbstractClassMetaData targetCmd = nucleusCtx.getMetaDataManager().getMetaDataForClass(className, clr);
        Object discriminatorValue = targetCmd.getDiscriminatorValue();
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            String strValue = null;
            if (targetCmd.getInheritanceMetaData() != null && targetCmd.getInheritanceMetaData().getDiscriminatorMetaData() != null) {
                strValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
            if (strValue == null) {
                strValue = className;
            }
            if (discriminatorMapping instanceof DiscriminatorMapping.DiscriminatorLongMapping) {
                try {
                    discriminatorValue = Integer.valueOf(strValue);
                }
                catch (NumberFormatException nfe) {
                    throw new NucleusUserException("Discriminator for " + className + " is not integer-based but needs to be!");
                }
            } else {
                discriminatorValue = strValue;
            }
        }
        return discriminatorValue;
    }

    public static List getDiscriminatorValuesForMember(String className, JavaTypeMapping discMapping, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ArrayList<Object> discrimValues = new ArrayList<Object>();
        DiscriminatorStrategy strategy = discMapping.getTable().getDiscriminatorMetaData().getStrategy();
        if (strategy != DiscriminatorStrategy.NONE) {
            MetaDataManager mmgr = storeMgr.getMetaDataManager();
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
            discrimValues.add(cmd.getDiscriminatorValue());
            Collection subclasses = storeMgr.getSubClassesForClass(className, true, clr);
            if (subclasses != null && subclasses.size() > 0) {
                for (String subclassName : subclasses) {
                    AbstractClassMetaData subclassCmd = mmgr.getMetaDataForClass(subclassName, clr);
                    discrimValues.add(subclassCmd.getDiscriminatorValue());
                }
            }
        }
        return discrimValues;
    }
}

