/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFilterManager;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.util.PartitionSet;

public class BaseReplacePartitions
extends MergingSnapshotProducer<ReplacePartitions>
implements ReplacePartitions {
    private final PartitionSet replacedPartitions;
    private Long startingSnapshotId;
    private boolean validateConflictingData = false;
    private boolean validateConflictingDeletes = false;

    BaseReplacePartitions(String tableName, TableOperations ops) {
        super(tableName, ops);
        this.set("replace-partitions", "true");
        this.replacedPartitions = PartitionSet.create(ops.current().specsById());
    }

    @Override
    protected ReplacePartitions self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    @Override
    public ReplacePartitions addFile(DataFile file) {
        this.dropPartition(file.specId(), file.partition());
        this.replacedPartitions.add(file.specId(), file.partition());
        this.add(file);
        return this;
    }

    @Override
    public ReplacePartitions validateAppendOnly() {
        this.failAnyDelete();
        return this;
    }

    @Override
    public ReplacePartitions validateFromSnapshot(long newStartingSnapshotId) {
        this.startingSnapshotId = newStartingSnapshotId;
        return this;
    }

    @Override
    public ReplacePartitions validateNoConflictingDeletes() {
        this.validateConflictingDeletes = true;
        return this;
    }

    @Override
    public ReplacePartitions validateNoConflictingData() {
        this.validateConflictingData = true;
        return this;
    }

    @Override
    public BaseReplacePartitions toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    public void validate(TableMetadata currentMetadata, Snapshot parent) {
        if (this.validateConflictingData) {
            if (this.dataSpec().isUnpartitioned()) {
                this.validateAddedDataFiles(currentMetadata, this.startingSnapshotId, Expressions.alwaysTrue(), parent);
            } else {
                this.validateAddedDataFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions, parent);
            }
        }
        if (this.validateConflictingDeletes) {
            if (this.dataSpec().isUnpartitioned()) {
                this.validateDeletedDataFiles(currentMetadata, this.startingSnapshotId, Expressions.alwaysTrue(), parent);
                this.validateNoNewDeleteFiles(currentMetadata, this.startingSnapshotId, Expressions.alwaysTrue(), parent);
            } else {
                this.validateDeletedDataFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions, parent);
                this.validateNoNewDeleteFiles(currentMetadata, this.startingSnapshotId, this.replacedPartitions, parent);
            }
        }
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base, Snapshot snapshot) {
        if (this.dataSpec().fields().isEmpty()) {
            this.deleteByRowFilter(Expressions.alwaysTrue());
        }
        try {
            return super.apply(base, snapshot);
        }
        catch (ManifestFilterManager.DeleteException e) {
            throw new ValidationException("Cannot commit file that conflicts with existing partition: %s", e.partition());
        }
    }
}

