# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

BEGIN {
    
    A["ServerRoot"] = BDIR
    A["FTPPort"] = FTPPORT
    A["ftpdocsdir"] = FTPROOT
    A["logfiledir"] = "logs"
    A["runtimedir"] = "logs"
    A["sysconfdir"] = "conf"

    B["ftpdocsdir"] = A["ServerRoot"]"/"A["ftpdocsdir"]
    B["sysconfdir"] = A["ServerRoot"]"/"A["sysconfdir"]
    B["runtimedir"] = A["ServerRoot"]"/"A["runtimedir"]
}

/#@@LoadFtpModules@@/ {
    print "LoadModule ftp_module modules/mod_ftp."SOEXT
    next
}

match ($0,/^#SSLSessionCache +"dbm:/) {
    sub(/^#/, "")
}

match ($0,/^SSLSessionCache +"shmcb:/) {
    sub(/^SSLSessionCache/, "#SSLSessionCache")
}

match ($0,/SSLMutex +"file:@exp_runtimedir@\/ssl_mutex"/) {
    sub(/"file:@exp_runtimedir@\/ssl_mutex"/, "default")
}

match ($0,/@@.*@@/) {
    s=substr($0,RSTART+2,RLENGTH-4)
    sub(/@@.*@@/,A[s],$0)
}

match ($0,/@rel_.*@/) {
    s=substr($0,RSTART+5,RLENGTH-6)
    sub(/@rel_.*@/,A[s],$0)
}

match ($0,/@exp_.*@/) {
    s=substr($0,RSTART+5,RLENGTH-6)
    sub(/@exp_.*@/,B[s],$0)
}

match ($0,/@nonssl_.*@/) {
    s=substr($0,RSTART+8,RLENGTH-9)
    sub(/@nonssl_.*@/,B[s],$0)
}

{
    print
}


END {
    print ""
}


