/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.internal.UserAgentUtils;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsRequest;
import software.amazon.awssdk.services.glue.model.ListColumnStatisticsTaskRunsResponse;

public class ListColumnStatisticsTaskRunsIterable
implements SdkIterable<ListColumnStatisticsTaskRunsResponse> {
    private final GlueClient client;
    private final ListColumnStatisticsTaskRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListColumnStatisticsTaskRunsIterable(GlueClient client, ListColumnStatisticsTaskRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListColumnStatisticsTaskRunsResponseFetcher();
    }

    public Iterator<ListColumnStatisticsTaskRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListColumnStatisticsTaskRunsResponseFetcher
    implements SyncPageFetcher<ListColumnStatisticsTaskRunsResponse> {
        private ListColumnStatisticsTaskRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListColumnStatisticsTaskRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListColumnStatisticsTaskRunsResponse nextPage(ListColumnStatisticsTaskRunsResponse previousPage) {
            if (previousPage == null) {
                return ListColumnStatisticsTaskRunsIterable.this.client.listColumnStatisticsTaskRuns(ListColumnStatisticsTaskRunsIterable.this.firstRequest);
            }
            return ListColumnStatisticsTaskRunsIterable.this.client.listColumnStatisticsTaskRuns((ListColumnStatisticsTaskRunsRequest)((Object)ListColumnStatisticsTaskRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

