/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;

public class CreateTableTransaction
implements Transaction {
    private final List<DataFile> appendDataFiles = Lists.newArrayList();
    private final Supplier<MixedTable> tableCreator;
    private final Runnable rollback;
    private final Transaction transaction;

    public CreateTableTransaction(Transaction transaction, Supplier<MixedTable> tableSupplier, Runnable rollback) {
        this.transaction = transaction;
        this.tableCreator = tableSupplier;
        this.rollback = rollback;
    }

    public Table table() {
        return this.transaction.table();
    }

    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException("create table transaction unsupported updateSchema");
    }

    public UpdatePartitionSpec updateSpec() {
        throw new UnsupportedOperationException("create table transaction unsupported updateSpec");
    }

    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException("create table transaction unsupported updateProperties");
    }

    public ReplaceSortOrder replaceSortOrder() {
        throw new UnsupportedOperationException("create table transaction unsupported updateProperties");
    }

    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException("create table transaction unsupported updateProperties");
    }

    public AppendFiles newAppend() {
        return new AppendFiles(){
            private final List<DataFile> dataFiles = Lists.newArrayList();

            public AppendFiles appendFile(DataFile dataFile) {
                this.dataFiles.add(dataFile);
                return this;
            }

            public AppendFiles appendManifest(ManifestFile file) {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported ManifestFile");
            }

            public AppendFiles set(String property, String value) {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported set");
            }

            public AppendFiles deleteWith(Consumer<String> deleteFunc) {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported deleteWith");
            }

            public AppendFiles stageOnly() {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported stageOnly");
            }

            public AppendFiles scanManifestsWith(ExecutorService executorService) {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported scanManifestsWith");
            }

            public Snapshot apply() {
                throw new UnsupportedOperationException("create table transaction AppendFiles unsupported apply");
            }

            public void commit() {
                CreateTableTransaction.this.appendDataFiles.addAll(this.dataFiles);
            }
        };
    }

    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException("create table transaction unsupported newRewrite");
    }

    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException("create table transaction unsupported rewriteManifests");
    }

    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException("create table transaction unsupported newOverwrite");
    }

    public RowDelta newRowDelta() {
        throw new UnsupportedOperationException("create table transaction unsupported newRowDelta");
    }

    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException("create table transaction unsupported newReplacePartitions");
    }

    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException("create table transaction unsupported newReplacePartitions");
    }

    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException("create table transaction unsupported newReplacePartitions");
    }

    public void commitTransaction() {
        MixedTable table = this.tableCreator.get();
        try {
            Transaction tx = table.isUnkeyedTable() ? table.asUnkeyedTable().newTransaction() : table.asKeyedTable().baseTable().newTransaction();
            AppendFiles appendFiles = tx.newAppend();
            this.appendDataFiles.forEach(arg_0 -> ((AppendFiles)appendFiles).appendFile(arg_0));
            appendFiles.commit();
            tx.commitTransaction();
        }
        catch (Throwable t) {
            this.rollback.run();
            throw t;
        }
    }
}

