/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.Map;
import org.apache.amoro.optimizing.MetricsSummary;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.process.StagedTaskDescriptor;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.utils.SerializationUtil;
import org.apache.iceberg.ContentFile;

public class RewriteStageTask
extends StagedTaskDescriptor<RewriteFilesInput, RewriteFilesOutput, MetricsSummary> {
    private String partition;

    public RewriteStageTask() {
    }

    public RewriteStageTask(long tableId, String partition, RewriteFilesInput input, Map<String, String> properties) {
        super(tableId, (Object)input, properties);
        this.partition = partition;
    }

    protected void calculateSummary() {
        if (this.input != null) {
            this.summary = new MetricsSummary((RewriteFilesInput)this.input);
            if (this.output != null) {
                ((MetricsSummary)this.summary).setNewDataFileCnt(RewriteStageTask.getFileCount(((RewriteFilesOutput)this.output).getDataFiles()));
                ((MetricsSummary)this.summary).setNewDataSize(RewriteStageTask.getFileSize(((RewriteFilesOutput)this.output).getDataFiles()));
                ((MetricsSummary)this.summary).setNewDataRecordCnt(RewriteStageTask.getRecordCnt(((RewriteFilesOutput)this.output).getDataFiles()));
                ((MetricsSummary)this.summary).setNewDeleteFileCnt(RewriteStageTask.getFileCount(((RewriteFilesOutput)this.output).getDeleteFiles()));
                ((MetricsSummary)this.summary).setNewDeleteSize(RewriteStageTask.getFileSize(((RewriteFilesOutput)this.output).getDeleteFiles()));
                ((MetricsSummary)this.summary).setNewDeleteRecordCnt(RewriteStageTask.getRecordCnt(((RewriteFilesOutput)this.output).getDeleteFiles()));
                ((MetricsSummary)this.summary).setNewFileSize(((MetricsSummary)this.summary).getNewDataSize() + ((MetricsSummary)this.summary).getNewDeleteSize());
                ((MetricsSummary)this.summary).setNewFileCnt(((MetricsSummary)this.summary).getNewDataFileCnt() + ((MetricsSummary)this.summary).getNewDeleteFileCnt());
            }
        }
    }

    protected RewriteFilesOutput deserializeOutput(byte[] outputBytes) {
        return (RewriteFilesOutput)SerializationUtil.simpleDeserialize((byte[])outputBytes);
    }

    public String getPartition() {
        return this.partition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("tableId", this.tableId).add("partition", (Object)this.partition).add("input", this.input).add("output", this.output).add("properties", (Object)this.properties).toString();
    }

    private static long getFileSize(ContentFile<?>[] contentFiles) {
        long size = 0L;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                size += contentFile.fileSizeInBytes();
            }
        }
        return size;
    }

    private static int getFileCount(ContentFile<?>[] contentFiles) {
        return contentFiles == null ? 0 : contentFiles.length;
    }

    private static long getRecordCnt(ContentFile<?>[] contentFiles) {
        long recordCnt = 0L;
        if (contentFiles != null) {
            for (ContentFile<?> contentFile : contentFiles) {
                recordCnt += contentFile.recordCount();
            }
        }
        return recordCnt;
    }
}

