/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import java.util.Objects;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.source.SparkScan;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.spark.sql.SparkSession;

class SparkStagedScan
extends SparkScan {
    private final String taskSetId;
    private final long splitSize;
    private final int splitLookback;
    private final long openFileCost;
    private List<ScanTaskGroup<ScanTask>> taskGroups = null;

    SparkStagedScan(SparkSession spark, Table table, SparkReadConf readConf) {
        this(spark, table, table.schema(), readConf);
    }

    SparkStagedScan(SparkSession spark, Table table, Schema expectedSchema, SparkReadConf readConf) {
        super(spark, table, readConf, expectedSchema, (List<Expression>)ImmutableList.of());
        this.taskSetId = readConf.scanTaskSetId();
        this.splitSize = readConf.splitSize();
        this.splitLookback = readConf.splitLookback();
        this.openFileCost = readConf.splitOpenFileCost();
    }

    protected List<ScanTaskGroup<ScanTask>> taskGroups() {
        if (this.taskGroups == null) {
            ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
            List tasks = taskSetManager.fetchTasks(this.table(), this.taskSetId);
            ValidationException.check((tasks != null ? 1 : 0) != 0, (String)"Task set manager has no tasks for table %s with task set ID %s", (Object[])new Object[]{this.table(), this.taskSetId});
            this.taskGroups = TableScanUtil.planTaskGroups(tasks, (long)this.splitSize, (int)this.splitLookback, (long)this.openFileCost);
        }
        return this.taskGroups;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SparkStagedScan that = (SparkStagedScan)other;
        return this.table().name().equals(that.table().name()) && Objects.equals(this.taskSetId, that.taskSetId) && this.readSchema().equals((Object)that.readSchema()) && Objects.equals(this.splitSize, that.splitSize) && Objects.equals(this.splitLookback, that.splitLookback) && Objects.equals(this.openFileCost, that.openFileCost);
    }

    public int hashCode() {
        return Objects.hash(this.table().name(), this.taskSetId, this.readSchema(), this.splitSize, this.splitSize, this.openFileCost);
    }

    public String toString() {
        return String.format("IcebergStagedScan(table=%s, type=%s, taskSetID=%s, caseSensitive=%s)", this.table(), this.expectedSchema().asStruct(), this.taskSetId, this.caseSensitive());
    }
}

