/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.AsyncRetryStrategy;
import org.apache.flink.streaming.api.operators.async.AsyncWaitOperatorFactory;
import org.apache.flink.streaming.util.retryable.AsyncRetryStrategies;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AsyncDataStream {
    private static final int DEFAULT_QUEUE_CAPACITY = 100;

    private static <IN, OUT> SingleOutputStreamOperator<OUT> addOperator(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, int bufSize, OutputMode mode, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        if (asyncRetryStrategy != AsyncRetryStrategies.NO_RETRY_STRATEGY) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Timeout should be configured when do async with retry.");
        }
        TypeInformation outTypeInfo = TypeExtractor.getUnaryOperatorReturnType(func, AsyncFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, in.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        AsyncWaitOperatorFactory<IN, OUT> operatorFactory = new AsyncWaitOperatorFactory<IN, OUT>(in.getExecutionEnvironment().clean(func), timeout, bufSize, mode, asyncRetryStrategy);
        return in.transform("async wait operator", outTypeInfo, operatorFactory);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> unorderedWait(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, int capacity) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), capacity, OutputMode.UNORDERED, AsyncRetryStrategies.NO_RETRY_STRATEGY);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> unorderedWait(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), 100, OutputMode.UNORDERED, AsyncRetryStrategies.NO_RETRY_STRATEGY);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> orderedWait(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, int capacity) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), capacity, OutputMode.ORDERED, AsyncRetryStrategies.NO_RETRY_STRATEGY);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> orderedWait(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), 100, OutputMode.ORDERED, AsyncRetryStrategies.NO_RETRY_STRATEGY);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> unorderedWaitWithRetry(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), 100, OutputMode.UNORDERED, asyncRetryStrategy);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> unorderedWaitWithRetry(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, int capacity, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), capacity, OutputMode.UNORDERED, asyncRetryStrategy);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> orderedWaitWithRetry(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), 100, OutputMode.ORDERED, asyncRetryStrategy);
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> orderedWaitWithRetry(DataStream<IN> in, AsyncFunction<IN, OUT> func, long timeout, TimeUnit timeUnit, int capacity, AsyncRetryStrategy<OUT> asyncRetryStrategy) {
        return AsyncDataStream.addOperator(in, func, timeUnit.toMillis(timeout), capacity, OutputMode.ORDERED, asyncRetryStrategy);
    }

    public static enum OutputMode {
        ORDERED,
        UNORDERED;

    }
}

