/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.RESTResponse;

public class ErrorResponse
implements RESTResponse {
    private String message;
    private String type;
    private int code;
    private List<String> stack;

    private ErrorResponse(String message, String type, int code, List<String> stack) {
        this.message = message;
        this.type = type;
        this.code = code;
        this.stack = stack;
        this.validate();
    }

    @Override
    public void validate() {
    }

    public String message() {
        return this.message;
    }

    public String type() {
        return this.type;
    }

    public Integer code() {
        return this.code;
    }

    public List<String> stack() {
        return this.stack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorResponse(").append("code=").append(this.code).append(", type=").append(this.type).append(", message=").append(this.message).append(")");
        if (this.stack != null && !this.stack.isEmpty()) {
            for (String line : this.stack) {
                sb.append("\n").append(line);
            }
        }
        return sb.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message;
        private String type;
        private Integer code;
        private List<String> stack;

        private Builder() {
        }

        public Builder withMessage(String errorMessage) {
            this.message = errorMessage;
            return this;
        }

        public Builder withType(String errorType) {
            this.type = errorType;
            return this;
        }

        public Builder withStackTrace(Throwable throwable) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                throwable.printStackTrace(pw);
            }
            this.stack = Arrays.asList(sw.toString().split("\n"));
            return this;
        }

        public Builder withStackTrace(List<String> trace) {
            this.stack = trace;
            return this;
        }

        public Builder responseCode(Integer responseCode) {
            this.code = responseCode;
            return this;
        }

        public ErrorResponse build() {
            Preconditions.checkArgument((this.code != null ? 1 : 0) != 0, (Object)"Invalid response, missing field: code");
            return new ErrorResponse(this.message, this.type, this.code, this.stack);
        }
    }
}

