/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergRequestContext;
import org.apache.gravitino.iceberg.service.IcebergRestUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergTableOperationDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTableEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTableEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergDropTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergListTableEvent;
import org.apache.gravitino.listener.api.event.IcebergListTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergListTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTableEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTableEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergRenameTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergTableExistsEvent;
import org.apache.gravitino.listener.api.event.IcebergTableExistsFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergTableExistsPreEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTableEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateTablePreEvent;
import org.apache.gravitino.utils.PrincipalUtils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;

public class IcebergTableEventDispatcher
implements IcebergTableOperationDispatcher {
    private IcebergTableOperationDispatcher icebergTableOperationDispatcher;
    private EventBus eventBus;
    private String metalakeName;

    public IcebergTableEventDispatcher(IcebergTableOperationDispatcher icebergTableOperationDispatcher, EventBus eventBus, String metalakeName) {
        this.icebergTableOperationDispatcher = icebergTableOperationDispatcher;
        this.eventBus = eventBus;
        this.metalakeName = metalakeName;
    }

    @Override
    public LoadTableResponse createTable(IcebergRequestContext context, Namespace namespace, CreateTableRequest createTableRequest) {
        LoadTableResponse loadTableResponse;
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)createTableRequest.name());
        NameIdentifier nameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTablePreEvent(PrincipalUtils.getCurrentUserName(), nameIdentifier, createTableRequest));
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.createTable(context, namespace, createTableRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTableFailureEvent(PrincipalUtils.getCurrentUserName(), nameIdentifier, createTableRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateTableEvent(PrincipalUtils.getCurrentUserName(), nameIdentifier, createTableRequest, loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public LoadTableResponse updateTable(IcebergRequestContext context, TableIdentifier tableIdentifier, UpdateTableRequest updateTableRequest) {
        LoadTableResponse loadTableResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTablePreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, updateTableRequest));
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.updateTable(context, tableIdentifier, updateTableRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTableFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, updateTableRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateTableEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, updateTableRequest, loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public void dropTable(IcebergRequestContext context, TableIdentifier tableIdentifier, boolean purgeRequested) {
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTablePreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, purgeRequested));
        try {
            this.icebergTableOperationDispatcher.dropTable(context, tableIdentifier, purgeRequested);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTableFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, purgeRequested, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropTableEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, purgeRequested));
    }

    @Override
    public LoadTableResponse loadTable(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        LoadTableResponse loadTableResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTablePreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier));
        try {
            loadTableResponse = this.icebergTableOperationDispatcher.loadTable(context, tableIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTableFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadTableEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, loadTableResponse));
        return loadTableResponse;
    }

    @Override
    public ListTablesResponse listTable(IcebergRequestContext context, Namespace namespace) {
        ListTablesResponse listTablesResponse;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListTablePreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier));
        try {
            listTablesResponse = this.icebergTableOperationDispatcher.listTable(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergListTableFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListTableEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier));
        return listTablesResponse;
    }

    @Override
    public boolean tableExists(IcebergRequestContext context, TableIdentifier tableIdentifier) {
        boolean isExists;
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsPreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier));
        try {
            isExists = this.icebergTableOperationDispatcher.tableExists(context, tableIdentifier);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergTableExistsEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, isExists));
        return isExists;
    }

    @Override
    public void renameTable(IcebergRequestContext context, RenameTableRequest renameTableRequest) {
        TableIdentifier sourceTable = renameTableRequest.source();
        NameIdentifier gravitinoNameIdentifier = IcebergRestUtils.getGravitinoNameIdentifier(this.metalakeName, context.getCatalogName(), sourceTable);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTablePreEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, renameTableRequest));
        try {
            this.icebergTableOperationDispatcher.renameTable(context, renameTableRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTableFailureEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, renameTableRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRenameTableEvent(PrincipalUtils.getCurrentUserName(), gravitinoNameIdentifier, renameTableRequest));
    }
}

