/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.hive;

import com.google.common.collect.ImmutableList;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import org.apache.gravitino.trino.connector.catalog.HasPropertyMeta;
import org.apache.gravitino.trino.connector.catalog.hive.SortingColumn;

public class HivePropertyMeta
implements HasPropertyMeta {
    static final String HIVE_SCHEMA_LOCATION = "location";
    private static final List<PropertyMetadata<?>> SCHEMA_PROPERTY_META = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"location", (String)"Hive storage location for the schema", null, (boolean)false));
    static final String HIVE_TABLE_FORMAT = "format";
    static final String HIVE_TABLE_TOTAL_SIZE = "total_size";
    static final String HIVE_TABLE_NUM_FILES = "num_files";
    static final String HIVE_TABLE_EXTERNAL = "external";
    static final String HIVE_TABLE_LOCATION = "location";
    static final String HIVE_TABLE_TYPE = "table_type";
    static final String HIVE_TABLE_INPUT_FORMAT = "input_format";
    static final String HIVE_TABLE_OUTPUT_FORMAT = "output_format";
    static final String HIVE_TABLE_SERDE_LIB = "serde_lib";
    static final String HIVE_TABLE_SERDE_NAME = "serde_name";
    static final String HIVE_PARTITION_KEY = "partitioned_by";
    static final String HIVE_BUCKET_KEY = "bucketed_by";
    static final String HIVE_BUCKET_COUNT_KEY = "bucket_count";
    static final String HIVE_SORT_ORDER_KEY = "sorted_by";
    private static final List<PropertyMetadata<?>> TABLE_PROPERTY_META = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"format", (String)"Hive storage format for the table", (String)"TEXTFILE", (boolean)false), (Object)PropertyMetadata.stringProperty((String)"total_size", (String)"total size of the table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"num_files", (String)"number of files", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"external", (String)"Indicate whether it is an external table", null, (boolean)true), (Object)PropertyMetadata.stringProperty((String)"location", (String)"HDFS location for table storage", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"table_type", (String)"The type of Hive table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"input_format", (String)"The input format class for the table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"output_format", (String)"The output format class for the table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"serde_lib", (String)"The serde library class for the table", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"serde_name", (String)"Name of the serde, table name by default", null, (boolean)false), (Object)new PropertyMetadata("partitioned_by", "Partition columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)new PropertyMetadata("bucketed_by", "Bucketing columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object[])new PropertyMetadata[]{PropertyMetadata.integerProperty((String)"bucket_count", (String)"The number of buckets for the table", null, (boolean)false), new PropertyMetadata("sorted_by", "Bucket sorting columns", (Type)new ArrayType((Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(String.class::cast).map(String::toLowerCase).map(SortingColumn::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> value.stream().map(SortingColumn.class::cast).map(SortingColumn::sortingColumnToString).collect(ImmutableList.toImmutableList()))});
    private static final List<PropertyMetadata<?>> CATALOG_PROPERTY_META = ImmutableList.of((Object)PropertyMetadata.enumProperty((String)"hive.storage-format".replace(".", "_"), (String)"hive.storage-format", CatalogStorageFormat.class, (Enum)CatalogStorageFormat.ORC, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"hive.compression-codec".replace(".", "_"), (String)"The compression codec to use when writing files.", CompressionCodec.class, (Enum)CompressionCodec.GZIP, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"hive.config.resources".replace(".", "_"), (String)"An optional comma-separated list of HDFS configuration files. These files must exist on the machines running Trino. Only specify this if absolutely necessary to access HDFS. Example: /etc/hdfs-site.xml", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.recursive-directories".replace(".", "_"), (String)"Enable reading data from subdirectories of table or partition locations. If disabled, subdirectories are ignored. This is equivalent to the hive.mapred.supports.subdirectories property in Hive.", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.ignore-absent-partitions".replace(".", "_"), (String)"Ignore partitions when the file system location does not exist rather than failing the query. This skips data that may be expected to be part of the table.", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.force-local-scheduling".replace(".", "_"), (String)"Force splits to be scheduled on the same node as the Hadoop DataNode process serving the split data.", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.respect-table-format".replace(".", "_"), (String)"Should new partitions be written using the existing table format or the default Trino format?", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.immutable-partitions".replace(".", "_"), (String)"Can new data be inserted into existing partitions?", (Boolean)false, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"hive.insert-existing-partitions-behavior".replace(".", "_"), (String)"What happens when data is inserted into an existing partition", InsertExistingPartitionsBehavior.class, (Enum)InsertExistingPartitionsBehavior.APPEND, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"hive.target-max-file-size".replace(".", "_"), (String)"Best effort maximum size of new files.", (String)"1GB", (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.create-empty-bucket-files".replace(".", "_"), (String)"Should empty files be created for buckets that have no data?", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"hive.validate-bucketing".replace(".", "_"), (String)"Enables validation that data is in the correct bucket when reading bucketed tables.", (Boolean)true, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.stringProperty((String)"hive.partition-statistics-sample-size".replace(".", "_"), (String)"Specifies the number of partitions to analyze when computing table statistics.", (String)"100", (boolean)false), PropertyMetadata.stringProperty((String)"hive.max-partitions-per-writers".replace(".", "_"), (String)"Specifies the number of partitions to analyze when computing table statistics.", (String)"100", (boolean)false), PropertyMetadata.stringProperty((String)"hive.max-partitions-for-eager-load".replace(".", "_"), (String)"The maximum number of partitions for a single table scan to load eagerly on the coordinator. Certain optimizations are not possible without eager loading.", (String)"100000", (boolean)false), PropertyMetadata.stringProperty((String)"hive.max-partitions-per-scan".replace(".", "_"), (String)"Maximum number of partitions for a single table scan.", (String)"1000000", (boolean)false)});

    @Override
    public List<PropertyMetadata<?>> getSchemaPropertyMetadata() {
        return SCHEMA_PROPERTY_META;
    }

    @Override
    public List<PropertyMetadata<?>> getTablePropertyMetadata() {
        return TABLE_PROPERTY_META;
    }

    @Override
    public List<PropertyMetadata<?>> getColumnPropertyMetadata() {
        return HasPropertyMeta.super.getColumnPropertyMetadata();
    }

    @Override
    public List<PropertyMetadata<?>> getCatalogPropertyMeta() {
        return CATALOG_PROPERTY_META;
    }

    static enum CatalogStorageFormat {
        AVRO,
        CSV,
        JSON,
        ORC,
        PARQUET,
        RCBINARY,
        RCTEXT,
        SEQUENCEFILE,
        TEXTFILE;

    }

    static enum CompressionCodec {
        GZIP,
        SNAPPY,
        ZSTD,
        NONE;

    }

    static enum InsertExistingPartitionsBehavior {
        ERROR,
        IGNORE,
        OVERWRITE,
        APPEND;

    }
}

