/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.GCSTokenCredential;
import org.apache.gravitino.credential.S3SecretKeyCredential;
import org.apache.gravitino.credential.S3TokenCredential;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.shaded.com.google.common.collect.ImmutableMap;

public class CredentialPropertyUtils {
    @VisibleForTesting
    static final String ICEBERG_S3_ACCESS_KEY_ID = "s3.access-key-id";
    @VisibleForTesting
    static final String ICEBERG_S3_SECRET_ACCESS_KEY = "s3.secret-access-key";
    @VisibleForTesting
    static final String ICEBERG_S3_TOKEN = "s3.session-token";
    @VisibleForTesting
    static final String ICEBERG_GCS_TOKEN = "gcs.oauth2.token";
    private static Map<String, String> icebergCredentialPropertyMap = ImmutableMap.of("token", "gcs.oauth2.token", "s3-access-key-id", "s3.access-key-id", "s3-secret-access-key", "s3.secret-access-key", "s3-session-token", "s3.session-token");

    public static Map<String, String> toIcebergProperties(Credential credential) {
        if (credential instanceof GCSTokenCredential) {
            Map<String, String> icebergGCSCredentialProperties = CredentialPropertyUtils.transformProperties(credential.credentialInfo(), icebergCredentialPropertyMap);
            icebergGCSCredentialProperties.put("gcs.oauth2.token-expires-at", String.valueOf(credential.expireTimeInMs()));
            return icebergGCSCredentialProperties;
        }
        if (credential instanceof S3TokenCredential || credential instanceof S3SecretKeyCredential) {
            return CredentialPropertyUtils.transformProperties(credential.credentialInfo(), icebergCredentialPropertyMap);
        }
        return credential.toProperties();
    }

    private static Map<String, String> transformProperties(Map<String, String> originProperties, Map<String, String> transformMap) {
        HashMap<String, String> properties = new HashMap<String, String>();
        originProperties.forEach((k, v) -> {
            if (transformMap.containsKey(k)) {
                properties.put((String)transformMap.get(k), (String)v);
            }
        });
        return properties;
    }
}

