/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.ManagedSchemaOperations;
import org.apache.gravitino.catalog.model.ModelImpl;
import org.apache.gravitino.catalog.model.ModelVersionImpl;
import org.apache.gravitino.connector.CatalogInfo;
import org.apache.gravitino.connector.CatalogOperations;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.exceptions.ModelAlreadyExistsException;
import org.apache.gravitino.exceptions.ModelVersionAliasesAlreadyExistException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchModelException;
import org.apache.gravitino.exceptions.NoSuchModelVersionException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.ModelEntity;
import org.apache.gravitino.meta.ModelVersionEntity;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.model.ModelCatalog;
import org.apache.gravitino.model.ModelVersion;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.apache.gravitino.utils.PrincipalUtils;

public class ModelCatalogOperations
extends ManagedSchemaOperations
implements CatalogOperations,
ModelCatalog {
    private static final int INIT_VERSION = 0;
    private final EntityStore store;

    public ModelCatalogOperations(EntityStore store) {
        this.store = store;
    }

    public void initialize(Map<String, String> config, CatalogInfo info, HasPropertyMetadata propertiesMetadata) throws RuntimeException {
    }

    public void close() throws IOException {
    }

    public void testConnection(NameIdentifier catalogIdent, Catalog.Type type, String provider, String comment, Map<String, String> properties) {
    }

    protected EntityStore store() {
        return this.store;
    }

    public NameIdentifier[] listModels(Namespace namespace) throws NoSuchSchemaException {
        NamespaceUtil.checkModel((Namespace)namespace);
        try {
            List models = this.store.list(namespace, ModelEntity.class, Entity.EntityType.MODEL);
            return (NameIdentifier[])models.stream().map(m -> NameIdentifier.of((Namespace)namespace, (String)m.name())).toArray(NameIdentifier[]::new);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{namespace});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list models under namespace " + namespace, ioe);
        }
    }

    public Model getModel(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        try {
            ModelEntity model = (ModelEntity)this.store.get(ident, Entity.EntityType.MODEL, ModelEntity.class);
            return this.toModelImpl(model);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get model " + ident, ioe);
        }
    }

    public Model registerModel(NameIdentifier ident, String comment, Map<String, String> properties) throws ModelAlreadyExistsException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property string identifier should not be null");
        ModelEntity model = ModelEntity.builder().withId(Long.valueOf(stringId.id())).withName(ident.name()).withNamespace(ident.namespace()).withComment(comment).withProperties(properties).withLatestVersion(Integer.valueOf(0)).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)model, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to register model " + ident, e);
        }
        catch (EntityAlreadyExistsException e) {
            throw new ModelAlreadyExistsException((Throwable)e, "Model %s already exists", new Object[]{ident});
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchSchemaException((Throwable)e, "Schema %s does not exist", new Object[]{ident.namespace()});
        }
        return this.toModelImpl(model);
    }

    public boolean deleteModel(NameIdentifier ident) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        try {
            return this.store.delete(ident, Entity.EntityType.MODEL);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete model " + ident, ioe);
        }
    }

    public int[] listModelVersions(NameIdentifier ident) throws NoSuchModelException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        Namespace modelVersionNs = NamespaceUtil.toModelVersionNs((NameIdentifier)ident);
        try {
            List versions = this.store.list(modelVersionNs, ModelVersionEntity.class, Entity.EntityType.MODEL_VERSION);
            return versions.stream().mapToInt(ModelVersionEntity::version).toArray();
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to list model versions for model " + ident, ioe);
        }
    }

    public ModelVersion getModelVersion(NameIdentifier ident, int version) throws NoSuchModelVersionException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalGetModelVersion(modelVersionIdent);
    }

    public ModelVersion getModelVersion(NameIdentifier ident, String alias) throws NoSuchModelVersionException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalGetModelVersion(modelVersionIdent);
    }

    public void linkModelVersion(NameIdentifier ident, String uri, String[] aliases, String comment, Map<String, String> properties) throws NoSuchModelException, ModelVersionAliasesAlreadyExistException {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        StringIdentifier stringId = StringIdentifier.fromProperties(properties);
        Preconditions.checkArgument((stringId != null ? 1 : 0) != 0, (Object)"Property string identifier should not be null");
        ArrayList aliasList = aliases == null ? Lists.newArrayList() : Lists.newArrayList((Object[])aliases);
        ModelVersionEntity modelVersion = ModelVersionEntity.builder().withModelIdentifier(ident).withVersion(0).withAliases((List)aliasList).withUri(uri).withComment(comment).withProperties(properties).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put((Entity)modelVersion, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to link model version " + ident, e);
        }
        catch (EntityAlreadyExistsException e) {
            throw new ModelVersionAliasesAlreadyExistException((Throwable)e, "Model version aliases %s already exist", new Object[]{ident});
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelException((Throwable)e, "Model %s does not exist", new Object[]{ident});
        }
    }

    public boolean deleteModelVersion(NameIdentifier ident, int version) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (int)version);
        return this.internalDeleteModelVersion(modelVersionIdent);
    }

    public boolean deleteModelVersion(NameIdentifier ident, String alias) {
        NameIdentifierUtil.checkModel((NameIdentifier)ident);
        NameIdentifier modelVersionIdent = NameIdentifierUtil.toModelVersionIdentifier((NameIdentifier)ident, (String)alias);
        return this.internalDeleteModelVersion(modelVersionIdent);
    }

    private ModelImpl toModelImpl(ModelEntity model) {
        return (ModelImpl)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)((ModelImpl.Builder)ModelImpl.builder().withName(model.name())).withComment(model.comment())).withProperties(model.properties())).withLatestVersion(model.latestVersion())).withAuditInfo(model.auditInfo())).build();
    }

    private ModelVersionImpl toModelVersionImpl(ModelVersionEntity modelVersion) {
        return (ModelVersionImpl)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)((ModelVersionImpl.Builder)ModelVersionImpl.builder().withVersion(modelVersion.version())).withAliases(modelVersion.aliases().toArray(new String[0]))).withUri(modelVersion.uri())).withComment(modelVersion.comment())).withProperties(modelVersion.properties())).withAuditInfo(modelVersion.auditInfo())).build();
    }

    private ModelVersion internalGetModelVersion(NameIdentifier ident) {
        try {
            ModelVersionEntity modelVersion = (ModelVersionEntity)this.store.get(ident, Entity.EntityType.MODEL_VERSION, ModelVersionEntity.class);
            return this.toModelVersionImpl(modelVersion);
        }
        catch (NoSuchEntityException e) {
            throw new NoSuchModelVersionException((Throwable)e, "Model version %s does not exist", new Object[]{ident});
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get model version " + ident, ioe);
        }
    }

    private boolean internalDeleteModelVersion(NameIdentifier ident) {
        try {
            return this.store.delete(ident, Entity.EntityType.MODEL_VERSION);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to delete model version " + ident, ioe);
        }
    }
}

