/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.TimeZone;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.DateTimeUtils;

class TimestampToStringCastRule
extends AbstractCastRule<Timestamp, BinaryString> {
    static final TimestampToStringCastRule INSTANCE = new TimestampToStringCastRule();

    private TimestampToStringCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.TIMESTAMP).target((DataType)VarCharType.STRING_TYPE).build());
    }

    @Override
    public CastExecutor<Timestamp, BinaryString> create(DataType inputType, DataType targetType) {
        int precision = DataTypeChecks.getPrecision((DataType)inputType);
        TimeZone timeZone = inputType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? DateTimeUtils.LOCAL_TZ : DateTimeUtils.UTC_ZONE;
        return value -> BinaryString.fromString((String)DateTimeUtils.formatTimestamp((Timestamp)value, (TimeZone)timeZone, (int)precision));
    }
}

