/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.lang.reflect.Type;
import org.simpleflatmapper.util.TypeHelper;

public class TupleHelper {
    private TupleHelper() {
    }

    public static boolean isTuple(Type type) {
        return TupleHelper.isSfmTuple(type) || TupleHelper.isJoolTuple(type) || TupleHelper.isKotlinTuple(type);
    }

    private static boolean isKotlinTuple(Type type) {
        String className = TypeHelper.toClass(type).getName();
        return className.equals("kotlin.Pair") || className.equals("kotlin.Triple");
    }

    public static boolean isSfmTuple(Type type) {
        String className = TypeHelper.toClass(type).getName();
        return className.startsWith("org.simpleflatmapper.tuple.Tuple") && !className.endsWith("Tuples");
    }

    public static boolean isJoolTuple(Type type) {
        for (Class clazz = TypeHelper.toClass(type); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> i : clazz.getInterfaces()) {
                if (!"org.jooq.lambda.tuple.Tuple".equals(i.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

