/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.combiner;

import java.util.function.Supplier;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.combiner.PointerCombiner;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.store.entry.InlinePointer;
import org.apache.hugegraph.computer.core.store.entry.Pointer;

public abstract class AbstractPointerCombiner<T extends Readable & Writable>
implements PointerCombiner {
    protected T v1;
    protected T v2;
    protected T result;
    protected Combiner<T> combiner;
    protected BytesOutput output;

    public AbstractPointerCombiner(Supplier<T> supplier, Combiner<T> combiner) {
        this.v1 = (Readable)supplier.get();
        this.v2 = (Readable)supplier.get();
        this.result = (Readable)supplier.get();
        this.combiner = combiner;
        this.output = IOFactory.createBytesOutput(32);
    }

    @Override
    public Pointer combine(Pointer v1, Pointer v2) {
        try {
            RandomAccessInput input1 = v1.input();
            RandomAccessInput input2 = v2.input();
            input1.seek(v1.offset());
            input2.seek(v2.offset());
            this.v1.read(input1);
            this.v2.read(input2);
            this.combiner.combine(this.v1, this.v2, this.result);
            this.output.seek(0L);
            ((Writable)this.result).write((RandomAccessOutput)this.output);
            return new InlinePointer(this.output.buffer(), this.output.position());
        }
        catch (Exception e) {
            throw new ComputerException("Failed to combine pointer1(offset=%s, length=%s) and pointer2(offset=%s, length=%s)'", (Throwable)e, new Object[]{v1.offset(), v1.length(), v2.offset(), v2.length()});
        }
    }
}

