/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.edge;

import java.util.Objects;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.Value;

public class DefaultEdge
implements Edge {
    private String label;
    private String name;
    private Id targetId;
    private Properties properties;

    public DefaultEdge(GraphFactory graphFactory) {
        this(graphFactory, "", "", null);
    }

    public DefaultEdge(GraphFactory graphFactory, String label, String name, Id targetId) {
        this.label = label;
        this.name = name;
        this.targetId = targetId;
        this.properties = graphFactory.createProperties();
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public Id targetId() {
        return this.targetId;
    }

    public void targetId(Id targetId) {
        this.targetId = targetId;
    }

    public Properties properties() {
        return this.properties;
    }

    public void properties(Properties properties) {
        this.properties = properties;
    }

    public <T extends Value> T property(String key) {
        return (T)this.properties.get(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultEdge)) {
            return false;
        }
        DefaultEdge other = (DefaultEdge)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.name, other.name) && this.properties.equals(other.properties);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.name, this.targetId, this.properties);
    }

    public String toString() {
        return String.format("DefaultEdge{label=%s, name=%s, targetId=%s}", this.label, this.name, this.targetId);
    }
}

