/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.id.BytesId;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.BooleanValue;
import org.apache.hugegraph.computer.core.graph.value.DoubleValue;
import org.apache.hugegraph.computer.core.graph.value.FloatValue;
import org.apache.hugegraph.computer.core.graph.value.IntValue;
import org.apache.hugegraph.computer.core.graph.value.ListValue;
import org.apache.hugegraph.computer.core.graph.value.LongValue;
import org.apache.hugegraph.computer.core.graph.value.NullValue;
import org.apache.hugegraph.computer.core.graph.value.StringValue;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.util.E;

public final class HugeConverter {
    private static final GraphFactory GRAPH_FACTORY = ComputerContext.instance().graphFactory();

    public static Id convertId(Object rawId) {
        E.checkArgumentNotNull((Object)rawId, (String)"The rawId can't be null", (Object[])new Object[0]);
        if (rawId instanceof Number) {
            return BytesId.of(((Number)rawId).longValue());
        }
        if (rawId instanceof String) {
            return BytesId.of((String)rawId);
        }
        if (rawId instanceof UUID) {
            return BytesId.of((UUID)rawId);
        }
        throw new ComputerException("Can't convert to Id from '%s'(%s)", new Object[]{rawId, rawId.getClass()});
    }

    public static Value.Tvalue<?> convertValue(Object rawValue) {
        if (rawValue == null) {
            return NullValue.get();
        }
        if (rawValue instanceof Boolean) {
            return new BooleanValue(((Boolean)rawValue).booleanValue());
        }
        if (rawValue instanceof Integer) {
            return new IntValue(((Integer)rawValue).intValue());
        }
        if (rawValue instanceof Long) {
            return new LongValue(((Long)rawValue).longValue());
        }
        if (rawValue instanceof Float) {
            return new FloatValue(((Float)rawValue).floatValue());
        }
        if (rawValue instanceof Double) {
            return new DoubleValue(((Double)rawValue).doubleValue());
        }
        if (rawValue instanceof String) {
            return new StringValue((String)rawValue);
        }
        if (rawValue instanceof Collection) {
            Collection collection = (Collection)rawValue;
            ListValue listValue = new ListValue();
            for (Object nestedRawValue : collection) {
                listValue.add(HugeConverter.convertValue(nestedRawValue));
            }
            return listValue;
        }
        throw new ComputerException("Can't convert to Value from '%s'(%s)", new Object[]{rawValue, rawValue.getClass()});
    }

    public static Properties convertProperties(Map<String, Object> rawProperties) {
        Properties properties = GRAPH_FACTORY.createProperties();
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String key = entry.getKey();
            Value.Tvalue<?> value = HugeConverter.convertValue(entry.getValue());
            properties.put(key, value);
        }
        return properties;
    }
}

