/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class ServerIdleHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = Log.logger(ServerIdleHandler.class);

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            try {
                LOG.info("Connection idle, close connection to '{}' from server side", (Object)TransportUtil.remoteAddress(ctx.channel()));
                ctx.close();
            }
            catch (Exception e) {
                LOG.warn("Exception caught when closing connection to '{}' in ServerIdleHandler", (Object)TransportUtil.remoteAddress(ctx.channel()), (Object)e);
                throw e;
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

