/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class FrameDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger LOG = Log.logger(FrameDecoder.class);
    private static final int LENGTH_ADJUSTMENT = 0;
    private static final int INITIAL_BYTES_TO_STRIP = 0;

    public FrameDecoder() {
        super(Integer.MAX_VALUE, 12, 4, 0, 0);
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf msg = (ByteBuf)super.decode(ctx, in);
        if (msg == null) {
            return null;
        }
        short magicNumber = msg.readShort();
        if (magicNumber != 18503) {
            LOG.warn("Network stream corrupted: received incorrect magic number: {}, remote address: {}", (Object)magicNumber, (Object)TransportUtil.remoteAddress(ctx.channel()));
            msg.release();
            return null;
        }
        byte version = msg.readByte();
        if (version != 1) {
            LOG.warn("Network stream corrupted: received incorrect protocol version: {}, remote address: {}", (Object)version, (Object)TransportUtil.remoteAddress(ctx.channel()));
            msg.release();
            return null;
        }
        return msg;
    }
}

