/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.MessageHandler;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.receiver.edge.EdgeMessageRecvPartitions;
import org.apache.hugegraph.computer.core.receiver.message.ComputeMessageRecvPartitions;
import org.apache.hugegraph.computer.core.receiver.vertex.VertexMessageRecvPartitions;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.computer.core.store.FileManager;
import org.apache.hugegraph.computer.core.store.SuperstepFileGenerator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class MessageRecvManager
implements Manager,
MessageHandler {
    public static final String NAME = "message_recv";
    private static final Logger LOG = Log.logger(MessageRecvManager.class);
    private final ComputerContext context;
    private final FileManager fileManager;
    private final SortManager sortManager;
    private VertexMessageRecvPartitions vertexPartitions;
    private EdgeMessageRecvPartitions edgePartitions;
    private ComputeMessageRecvPartitions messagePartitions;
    private int workerCount;
    private int expectedFinishMessages;
    private CountDownLatch finishMessagesLatch;
    private long waitFinishMessagesTimeout;
    private long superstep;

    public MessageRecvManager(ComputerContext context, FileManager fileManager, SortManager sortManager) {
        this.context = context;
        this.fileManager = fileManager;
        this.sortManager = sortManager;
        this.superstep = -1L;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        SuperstepFileGenerator fileGenerator = new SuperstepFileGenerator(this.fileManager, -1);
        this.vertexPartitions = new VertexMessageRecvPartitions(this.context, fileGenerator, this.sortManager);
        this.edgePartitions = new EdgeMessageRecvPartitions(this.context, fileGenerator, this.sortManager);
        this.workerCount = (Integer)config.get((TypedOption)ComputerOptions.JOB_WORKERS_COUNT);
        this.expectedFinishMessages = this.workerCount * 2;
        this.finishMessagesLatch = new CountDownLatch(this.expectedFinishMessages);
        this.waitFinishMessagesTimeout = (Long)config.get((TypedOption)ComputerOptions.WORKER_WAIT_FINISH_MESSAGES_TIMEOUT);
    }

    @Override
    public void beforeSuperstep(Config config, int superstep) {
        SuperstepFileGenerator fileGenerator = new SuperstepFileGenerator(this.fileManager, superstep);
        this.messagePartitions = new ComputeMessageRecvPartitions(this.context, fileGenerator, this.sortManager);
        this.expectedFinishMessages = this.workerCount;
        this.finishMessagesLatch = new CountDownLatch(this.expectedFinishMessages);
        this.superstep = superstep;
        if (this.superstep == 0L) {
            assert (this.vertexPartitions != null);
            this.vertexPartitions.clearOldFiles(-1);
            this.vertexPartitions = null;
            assert (this.edgePartitions != null);
            this.edgePartitions.clearOldFiles(-1);
            this.edgePartitions = null;
        }
    }

    @Override
    public void afterSuperstep(Config config, int superstep) {
        if (superstep > 0) {
            this.messagePartitions.clearOldFiles(superstep - 1);
        }
    }

    @Override
    public void onChannelActive(ConnectionId connectionId) {
    }

    @Override
    public void onChannelInactive(ConnectionId connectionId) {
    }

    @Override
    public void exceptionCaught(TransportException cause, ConnectionId connectionId) {
        LOG.warn("Exception caught for connection:{}, root cause:", (Object)connectionId, (Object)cause);
    }

    public void waitReceivedAllMessages() {
        try {
            boolean status = this.finishMessagesLatch.await(this.waitFinishMessagesTimeout, TimeUnit.MILLISECONDS);
            if (!status) {
                throw new ComputerException("Expect %s finish-messages received in %s ms, %s absence in superstep %s", new Object[]{this.expectedFinishMessages, this.waitFinishMessagesTimeout, this.finishMessagesLatch.getCount(), this.superstep});
            }
        }
        catch (InterruptedException e) {
            throw new ComputerException("Thread is interrupted while waiting %s finish-messages received in %s ms, %s absence in superstep %s", (Throwable)e, new Object[]{this.expectedFinishMessages, this.waitFinishMessagesTimeout, this.finishMessagesLatch.getCount(), this.superstep});
        }
    }

    @Override
    public void handle(MessageType messageType, int partition, NetworkBuffer buffer) {
        switch (messageType) {
            case VERTEX: {
                this.vertexPartitions.addBuffer(partition, buffer);
                break;
            }
            case EDGE: {
                this.edgePartitions.addBuffer(partition, buffer);
                break;
            }
            case MSG: {
                this.messagePartitions.addBuffer(partition, buffer);
                break;
            }
            default: {
                throw new ComputerException("Unable handle NetworkBuffer with type '%s'", new Object[]{messageType.name()});
            }
        }
    }

    @Override
    public String genOutputPath(MessageType messageType, int partition) {
        switch (messageType) {
            case VERTEX: {
                return this.vertexPartitions.genOutputPath(partition);
            }
            case EDGE: {
                return this.edgePartitions.genOutputPath(partition);
            }
            case MSG: {
                return this.messagePartitions.genOutputPath(partition);
            }
        }
        throw new ComputerException("Unable generator output path with type '%s'", new Object[]{messageType.name()});
    }

    @Override
    public void onStarted(ConnectionId connectionId) {
        LOG.debug("ConnectionId {} started", (Object)connectionId);
    }

    @Override
    public void onFinished(ConnectionId connectionId) {
        LOG.debug("ConnectionId {} finished", (Object)connectionId);
        this.finishMessagesLatch.countDown();
    }

    public Map<Integer, PeekableIterator<KvEntry>> vertexPartitions() {
        E.checkState((this.vertexPartitions != null ? 1 : 0) != 0, (String)"The vertexPartitions can't be null", (Object[])new Object[0]);
        VertexMessageRecvPartitions partitions = this.vertexPartitions;
        return partitions.iterators();
    }

    public Map<Integer, PeekableIterator<KvEntry>> edgePartitions() {
        E.checkState((this.edgePartitions != null ? 1 : 0) != 0, (String)"The edgePartitions can't be null", (Object[])new Object[0]);
        EdgeMessageRecvPartitions partitions = this.edgePartitions;
        return partitions.iterators();
    }

    public Map<Integer, PeekableIterator<KvEntry>> messagePartitions() {
        E.checkState((this.messagePartitions != null ? 1 : 0) != 0, (String)"The messagePartitions can't be null", (Object[])new Object[0]);
        ComputeMessageRecvPartitions partitions = this.messagePartitions;
        this.messagePartitions = null;
        return partitions.iterators();
    }

    public Map<Integer, MessageStat> messageStats() {
        this.waitReceivedAllMessages();
        E.checkState((this.messagePartitions != null ? 1 : 0) != 0, (String)"The messagePartitions can't be null", (Object[])new Object[0]);
        return this.messagePartitions.messageStats();
    }
}

