/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.sort.DefaultSorter;
import org.apache.hugegraph.computer.core.sort.Sorter;
import org.apache.hugegraph.computer.core.sort.flusher.InnerSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.store.buffer.KvEntriesInput;
import org.apache.hugegraph.computer.core.store.buffer.KvEntriesWithFirstSubKvInput;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.file.bufferfile.BufferFileEntryBuilder;
import org.apache.hugegraph.computer.core.store.file.bufferfile.BufferFileEntryReader;
import org.apache.hugegraph.computer.core.store.file.bufferfile.BufferFileSubEntryReader;
import org.apache.hugegraph.computer.core.store.file.select.DisperseEvenlySelector;
import org.apache.hugegraph.computer.core.store.file.select.SelectedFiles;

public class BufferFileSorter
implements Sorter {
    private final DefaultSorter sorter;

    public BufferFileSorter(Config config) {
        this.sorter = new DefaultSorter(config);
    }

    @Override
    public void sortBuffer(RandomAccessInput input, InnerSortFlusher flusher, boolean withSubKv) throws Exception {
        try (KvEntriesInput entries = new KvEntriesInput(input, withSubKv);){
            this.sorter.sortBuffer(entries, flusher);
        }
    }

    @Override
    public void mergeBuffers(List<RandomAccessInput> inputs, OuterSortFlusher flusher, String output, boolean withSubKv) throws Exception {
        List<EntryIterator> entries = withSubKv ? inputs.stream().map(KvEntriesWithFirstSubKvInput::new).collect(Collectors.toList()) : inputs.stream().map(KvEntriesInput::new).collect(Collectors.toList());
        try (BufferFileEntryBuilder writer = new BufferFileEntryBuilder(output);){
            this.sorter.mergeBuffers(entries, writer, flusher);
        }
    }

    @Override
    public void mergeInputs(List<String> inputs, OuterSortFlusher flusher, List<String> outputs, boolean withSubKv) throws Exception {
        Function<String, EntryIterator> fileToInput = withSubKv ? o -> new BufferFileSubEntryReader((String)o).iterator() : o -> new BufferFileEntryReader((String)o).iterator();
        Function<String, KvEntryFileWriter> fileToWriter = BufferFileEntryBuilder::new;
        DisperseEvenlySelector selector = new DisperseEvenlySelector();
        List<SelectedFiles> selectResult = selector.selectedByBufferFile(inputs, outputs);
        this.sorter.mergeFile(selectResult, fileToInput, fileToWriter, flusher);
    }

    @Override
    public PeekableIterator<KvEntry> iterator(List<String> inputs, boolean withSubKv) throws IOException {
        Function<String, EntryIterator> fileToEntries = input -> new BufferFileEntryReader((String)input, withSubKv).iterator();
        return this.sorter.iterator(inputs, fileToEntries);
    }
}

