/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.buffer;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class KvEntriesInput
implements EntryIterator {
    private final RandomAccessInput input;
    private final boolean withSubKv;
    private final RandomAccessInput userAccessInput;

    public KvEntriesInput(RandomAccessInput input, boolean withSubKv) {
        this.input = input;
        this.withSubKv = withSubKv;
        try {
            this.userAccessInput = this.input.duplicate();
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public KvEntriesInput(RandomAccessInput input) {
        this(input, false);
    }

    public boolean hasNext() {
        try {
            return this.input.available() > 0L;
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    public KvEntry next() {
        return EntriesUtil.kvEntryFromInput(this.input, this.userAccessInput, true, this.withSubKv);
    }

    public void close() throws IOException {
        this.input.close();
        this.userAccessInput.close();
    }
}

