/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.Pointer;
import org.apache.hugegraph.computer.core.util.BytesUtil;

public class CachedPointer
implements Pointer {
    private final RandomAccessInput input;
    private final long offset;
    private final long length;
    private byte[] bytes;

    public CachedPointer(RandomAccessInput input, long offset, long length) {
        this.input = input;
        this.offset = offset;
        this.length = length;
        this.bytes = null;
    }

    @Override
    public RandomAccessInput input() {
        return this.input;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte[] bytes() throws IOException {
        if (this.bytes == null) {
            this.input.seek(this.offset);
            this.bytes = this.input.readBytes((int)this.length);
        }
        return this.bytes;
    }

    @Override
    public void write(RandomAccessOutput output) throws IOException {
        output.writeFixedInt((int)this.length);
        output.write(this.bytes());
    }

    @Override
    public int compareTo(Pointer other) {
        try {
            return BytesUtil.compare((byte[])this.bytes(), (byte[])other.bytes());
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }
}

