/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.computer.core.store.entry.EntryOutput;
import org.apache.hugegraph.computer.core.store.entry.KvEntryWriter;
import org.apache.hugegraph.computer.core.store.entry.KvEntryWriterImpl;

public class EntryOutputImpl
implements EntryOutput {
    private final RandomAccessOutput output;
    private final boolean needSortSubKv;

    public EntryOutputImpl(RandomAccessOutput output, boolean needSortSubKv) {
        this.output = output;
        this.needSortSubKv = needSortSubKv;
    }

    public EntryOutputImpl(RandomAccessOutput output) {
        this(output, true);
    }

    @Override
    public KvEntryWriter writeEntry(Writable key) throws IOException {
        this.writeData(key);
        return new KvEntryWriterImpl(this.output, this.needSortSubKv);
    }

    @Override
    public void writeEntry(Writable key, Writable value) throws IOException {
        this.writeData(key);
        this.writeData(value);
    }

    private void writeData(Writable data) throws IOException {
        this.output.writeFixedInt(0);
        long position = this.output.position();
        data.write(this.output);
        int dataLength = (int)(this.output.position() - position);
        this.output.writeFixedInt(position - 4L, dataLength);
    }
}

