/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.entry;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.store.entry.KvEntryReader;

public class KvEntryReaderImpl
implements KvEntryReader {
    private final RandomAccessInput input;
    private int remaining;

    public KvEntryReaderImpl(RandomAccessInput input) {
        this.input = input;
        try {
            int totalLength = input.readFixedInt();
            this.remaining = input.readFixedInt();
        }
        catch (IOException e) {
            throw new ComputerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void readSubKv(Readable subKey, Readable subValue) throws IOException {
        this.readDataWithoutLength(subKey);
        this.readDataWithoutLength(subValue);
        --this.remaining;
    }

    @Override
    public boolean hasRemaining() throws IOException {
        return this.remaining > 0;
    }

    private void readDataWithoutLength(Readable data) throws IOException {
        data.read(this.input);
    }
}

