/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.select;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvDir;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvDirImpl;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFile;
import org.apache.hugegraph.computer.core.store.file.select.DefaultSelectedFiles;
import org.apache.hugegraph.computer.core.store.file.select.InputFilesSelector;
import org.apache.hugegraph.computer.core.store.file.select.SelectedFiles;
import org.apache.hugegraph.util.E;

public class DisperseEvenlySelector
implements InputFilesSelector {
    @Override
    public List<SelectedFiles> selectedByHgkvFile(List<String> inputs, List<String> outputs) throws IOException {
        int i;
        E.checkArgument((inputs.size() >= outputs.size() ? 1 : 0) != 0, (String)"The inputs size of InputFilesSelector must be >= outputs size, but got %s inputs < %s outputs", (Object[])new Object[]{inputs.size(), outputs.size()});
        List<Object> inputDirs = new ArrayList<HgkvDir>();
        for (String input : inputs) {
            inputDirs.add(HgkvDirImpl.open(input));
        }
        inputDirs = inputDirs.stream().sorted(Comparator.comparingLong(HgkvFile::numEntries).reversed()).collect(Collectors.toList());
        ArrayList<Node> heapNodes = new ArrayList<Node>(outputs.size());
        for (i = 0; i < outputs.size(); ++i) {
            HgkvDir inputDir = (HgkvDir)inputDirs.get(i);
            Node heapNode = new Node(inputDir.numEntries(), Lists.newArrayList((Object[])new String[]{inputDir.path()}), outputs.get(i));
            heapNodes.add(heapNode);
        }
        Heap<Node> heap = new Heap<Node>(heapNodes, Comparator.comparingLong(Node::num));
        while (i < inputDirs.size()) {
            HgkvDir inputDir = (HgkvDir)inputDirs.get(i);
            Node topNode = heap.top();
            topNode.addInput(inputDir.path());
            topNode.addNum(inputDir.numEntries());
            heap.adjust(0);
            ++i;
        }
        ArrayList<SelectedFiles> results = new ArrayList<SelectedFiles>();
        for (Node node : heapNodes) {
            DefaultSelectedFiles result = new DefaultSelectedFiles(node.output(), node.inputs());
            results.add(result);
        }
        return results;
    }

    @Override
    public List<SelectedFiles> selectedByBufferFile(List<String> inputs, List<String> outputs) {
        int i;
        E.checkArgument((inputs.size() >= outputs.size() ? 1 : 0) != 0, (String)"The inputs size of InputFilesSelector must be >= outputs size, but got %s inputs < %s outputs", (Object[])new Object[]{inputs.size(), outputs.size()});
        int size = outputs.size();
        ArrayList group = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            group.add(new ArrayList());
        }
        for (i = 0; i < inputs.size(); ++i) {
            List item = (List)group.get(i % size);
            item.add(inputs.get(i));
        }
        ArrayList<SelectedFiles> result = new ArrayList<SelectedFiles>();
        for (int i2 = 0; i2 < size; ++i2) {
            result.add(new DefaultSelectedFiles(outputs.get(i2), (List)group.get(i2)));
        }
        return result;
    }

    private static class Node {
        private long num;
        private final List<String> inputs;
        private final String output;

        public Node(long numEntries, List<String> inputs, String output) {
            this.num = numEntries;
            this.inputs = inputs;
            this.output = output;
        }

        public long num() {
            return this.num;
        }

        public void addNum(long num) {
            this.num += num;
        }

        public List<String> inputs() {
            return this.inputs;
        }

        public void addInput(String input) {
            this.inputs.add(input);
        }

        public String output() {
            return this.output;
        }
    }

    private static class Heap<T> {
        private final List<T> data;
        private final Comparator<T> comparator;
        private final int size;

        public Heap(List<T> data, Comparator<T> comparator) {
            this.data = data;
            this.size = data.size();
            this.comparator = comparator;
            this.buildHeap(this.size);
        }

        private void buildHeap(int size) {
            for (int index = (size >> 1) - 1; index >= 0; --index) {
                this.adjust(index);
            }
        }

        private void adjust(int index) {
            int child;
            while ((child = (index << 1) + 1) < this.size) {
                if (child < this.size - 1 && this.compare(this.data.get(child), this.data.get(child + 1)) > 0) {
                    ++child;
                }
                if (this.compare(this.data.get(index), this.data.get(child)) <= 0) break;
                this.swap(index, child);
                index = child;
            }
        }

        private T top() {
            return this.data.get(0);
        }

        private void swap(int i, int j) {
            T tmp = this.data.get(i);
            this.data.set(i, this.data.get(j));
            this.data.set(j, tmp);
        }

        private int compare(T t1, T t2) {
            return this.comparator.compare(t1, t2);
        }
    }
}

