/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common;

import com.alipay.sofa.rpc.base.Sortable;
import com.alipay.sofa.rpc.common.struct.OrderedComparator;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SofaConfigs {
    private static final List<ExternalConfigLoader> CONFIG_LOADERS = new ArrayList<ExternalConfigLoader>();
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static Lock rLock = lock.readLock();
    private static Lock wLock = lock.writeLock();
    private static Properties config;

    public static synchronized Properties getConfig() {
        if (config == null) {
            try {
                String rpcConfig = "config/rpc-config.properties";
                InputStream ins = SofaConfigs.class.getClassLoader().getResourceAsStream(rpcConfig);
                if (ins == null) {
                    ins = Thread.currentThread().getContextClassLoader().getResourceAsStream(rpcConfig);
                }
                config = new Properties();
                config.load(ins);
            }
            catch (Exception e) {
                config = new Properties();
            }
        }
        return config;
    }

    public static int getIntegerValue(String key, int defaultValue) {
        return SofaConfigs.getIntegerValue(null, key, defaultValue);
    }

    public static int getIntegerValue(String appName, String key, int defaultValue) {
        String ret = SofaConfigs.getStringValue0(appName, key);
        return StringUtils.isEmpty(ret) ? defaultValue : CommonUtils.parseInt(ret, defaultValue);
    }

    public static boolean getBooleanValue(String key, boolean defaultValue) {
        return SofaConfigs.getBooleanValue(null, key, defaultValue);
    }

    public static boolean getBooleanValue(String appName, String key, boolean defaultValue) {
        String ret = SofaConfigs.getStringValue0(appName, key);
        return StringUtils.isEmpty(ret) ? defaultValue : CommonUtils.parseBoolean(ret, defaultValue);
    }

    public static String getStringValue(String key, String defaultValue) {
        return SofaConfigs.getStringValue(null, key, defaultValue);
    }

    public static String getStringValue(String appName, String key, String defaultValue) {
        String ret = SofaConfigs.getStringValue0(appName, key);
        return StringUtils.isEmpty(ret) ? defaultValue : ret.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringValue0(String appName, String key) {
        String ret = System.getProperty(key);
        if (StringUtils.isNotEmpty(ret)) {
            return ret;
        }
        rLock.lock();
        try {
            for (ExternalConfigLoader configLoader : CONFIG_LOADERS) {
                String string = ret = appName == null ? configLoader.getValue(key) : configLoader.getValue(appName, key);
                if (!StringUtils.isNotEmpty(ret)) continue;
                String string2 = ret;
                return string2;
            }
        }
        finally {
            rLock.unlock();
        }
        return SofaConfigs.getConfig().getProperty(key);
    }

    public static void registerExternalConfigLoader(ExternalConfigLoader configLoader) {
        wLock.lock();
        try {
            CONFIG_LOADERS.add(configLoader);
            Collections.sort(CONFIG_LOADERS, new OrderedComparator());
        }
        finally {
            wLock.unlock();
        }
    }

    public static void unRegisterExternalConfigLoader(ExternalConfigLoader configLoader) {
        wLock.lock();
        try {
            CONFIG_LOADERS.remove(configLoader);
            Collections.sort(CONFIG_LOADERS, new OrderedComparator());
        }
        finally {
            wLock.unlock();
        }
    }

    public static abstract class ExternalConfigLoader
    implements Sortable {
        @Override
        public int getOrder() {
            return 0;
        }

        public abstract String getValue(String var1);

        public abstract String getValue(String var1, String var2);
    }
}

