/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.dynamic;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.dynamic.DynamicConfigManager;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DynamicConfigManagerFactory {
    private static final ConcurrentMap<String, DynamicConfigManager> ALL_DYNAMICS = new ConcurrentHashMap<String, DynamicConfigManager>();
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicConfigManagerFactory.class);

    public static synchronized DynamicConfigManager getDynamicManager(String appName, String alias) {
        if (ALL_DYNAMICS.size() > 3 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Size of dynamic manager is greater than 3, Please check it!");
        }
        try {
            DynamicConfigManager registry = (DynamicConfigManager)ALL_DYNAMICS.get(alias);
            if (registry == null) {
                ExtensionClass<DynamicConfigManager> ext = ExtensionLoaderFactory.getExtensionLoader(DynamicConfigManager.class).getExtensionClass(alias);
                if (ext == null) {
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "DynamicConfigManager", alias));
                }
                registry = ext.getExtInstance(new Class[]{String.class}, new Object[]{appName});
                ALL_DYNAMICS.put(alias, registry);
            }
            return registry;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "DynamicConfigManager", alias), e);
        }
    }
}

