/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.event.ClientAfterSendEvent;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientBeforeSendEvent;
import com.alipay.sofa.rpc.event.ClientEndInvokeEvent;
import com.alipay.sofa.rpc.event.ClientStartInvokeEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ServerEndHandleEvent;
import com.alipay.sofa.rpc.event.ServerReceiveEvent;
import com.alipay.sofa.rpc.event.ServerSendEvent;
import com.alipay.sofa.rpc.event.SofaTracerSubscriber;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.module.Module;
import com.alipay.sofa.rpc.tracer.Tracer;
import com.alipay.sofa.rpc.tracer.TracerFactory;

@Extension(value="sofaTracer")
public class SofaTracerModule
implements Module {
    private SofaTracerSubscriber subscriber;

    public static boolean isEnable() {
        String traceName = RpcConfigs.getStringValue("default.tracer");
        return "sofaTracer".equals(traceName);
    }

    @Override
    public boolean needLoad() {
        return SofaTracerModule.isEnable();
    }

    @Override
    public void install() {
        Tracer tracer = TracerFactory.getTracer("sofaTracer");
        if (tracer != null) {
            this.subscriber = new SofaTracerSubscriber();
            EventBus.register(ClientStartInvokeEvent.class, this.subscriber);
            EventBus.register(ClientBeforeSendEvent.class, this.subscriber);
            EventBus.register(ClientAfterSendEvent.class, this.subscriber);
            EventBus.register(ServerReceiveEvent.class, this.subscriber);
            EventBus.register(ServerSendEvent.class, this.subscriber);
            EventBus.register(ServerEndHandleEvent.class, this.subscriber);
            EventBus.register(ClientSyncReceiveEvent.class, this.subscriber);
            EventBus.register(ClientAsyncReceiveEvent.class, this.subscriber);
            EventBus.register(ClientEndInvokeEvent.class, this.subscriber);
        }
    }

    @Override
    public void uninstall() {
        if (this.subscriber != null) {
            EventBus.unRegister(ClientStartInvokeEvent.class, this.subscriber);
            EventBus.unRegister(ClientBeforeSendEvent.class, this.subscriber);
            EventBus.unRegister(ClientAfterSendEvent.class, this.subscriber);
            EventBus.unRegister(ServerReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ServerSendEvent.class, this.subscriber);
            EventBus.unRegister(ServerEndHandleEvent.class, this.subscriber);
            EventBus.unRegister(ClientSyncReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ClientAsyncReceiveEvent.class, this.subscriber);
            EventBus.unRegister(ClientEndInvokeEvent.class, this.subscriber);
        }
    }
}

