/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.Map;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.PropertyMeta;

public class MapKeyValueElementPropertyMeta<T extends Map<K, V>, K, V>
extends PropertyMeta<T, KeyValue<K, V>> {
    private final Type propertyType;
    private final MapSetter<T, K, V> setter;

    public MapKeyValueElementPropertyMeta(Type ownerType, ReflectionService reflectService, Type propertyType) {
        super("entry", ownerType, reflectService);
        this.propertyType = propertyType;
        this.setter = new MapSetter();
    }

    @Override
    public Setter<T, KeyValue<K, V>> getSetter() {
        return this.setter;
    }

    @Override
    public Getter<T, KeyValue<K, V>> getGetter() {
        return NullGetter.getter();
    }

    @Override
    public Type getPropertyType() {
        return this.propertyType;
    }

    @Override
    public String getPath() {
        return this.getName();
    }

    @Override
    public PropertyMeta<T, KeyValue<K, V>> withReflectionService(ReflectionService reflectionService) {
        return new MapKeyValueElementPropertyMeta<T, K, V>(this.getOwnerType(), reflectionService, this.propertyType);
    }

    @Override
    public PropertyMeta<T, KeyValue<K, V>> toNonMapped() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "MapKeyValueElementPropertyMeta{}";
    }

    public static class KeyValue<K, V> {
        private final K key;
        private final V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    private static class MapSetter<T extends Map<K, V>, K, V>
    implements Setter<T, KeyValue<K, V>> {
        private MapSetter() {
        }

        @Override
        public void set(T target, KeyValue<K, V> value) throws Exception {
            target.put(value.getKey(), value.getValue());
        }
    }
}

