/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.graph.value;

import org.apache.hugegraph.computer.core.graph.value.ValueType;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.io.Writable;
import org.apache.hugegraph.util.E;

public interface Value
extends Writable,
Readable,
Comparable<Value> {
    public ValueType valueType();

    public void assign(Value var1);

    public Value copy();

    public Object value();

    default public void checkAssign(Value other) {
        if (other == null) {
            E.checkArgument((boolean)false, (String)"Can't assign null to %s", (Object[])new Object[]{this.getClass().getSimpleName()});
        } else if (!this.getClass().isAssignableFrom(other.getClass())) {
            E.checkArgument((boolean)false, (String)"Can't assign '%s'(%s) to %s", (Object[])new Object[]{other, other.getClass().getSimpleName(), this.getClass().getSimpleName()});
        }
    }

    default public boolean isNumber() {
        return false;
    }

    default public String string() {
        return String.valueOf(this.value());
    }

    public static interface CustomizeValue<T>
    extends Tvalue<T> {
        @Override
        default public ValueType valueType() {
            return ValueType.CUSTOMIZE_VALUE;
        }

        @Override
        default public void assign(Value value) {
            throw new UnsupportedOperationException("assign");
        }

        @Override
        default public Value copy() {
            throw new UnsupportedOperationException("copy");
        }

        @Override
        default public int compareTo(Value other) {
            throw new UnsupportedOperationException("compareTo");
        }
    }

    public static interface Tvalue<T>
    extends Value {
        public T value();
    }
}

