/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.ComputationContext;

public interface ReduceComputation<M extends Value>
extends Computation<M> {
    public M initialValue(ComputationContext var1, Vertex var2);

    @Override
    default public void compute0(ComputationContext context, Vertex vertex) {
        M result = this.initialValue(context, vertex);
        this.compute(context, vertex, Arrays.asList(result).iterator());
    }

    @Override
    default public void compute(ComputationContext context, Vertex vertex, Iterator<M> messages) {
        Combiner combiner = context.combiner();
        Object message = Combiner.combineAll(combiner, messages);
        Object result = this.computeMessage(context, vertex, message);
        if (result != null) {
            this.sendMessage(context, vertex, result);
        }
        this.updateState(vertex);
    }

    public M computeMessage(ComputationContext var1, Vertex var2, M var3);

    default public void sendMessage(ComputationContext context, Vertex vertex, M result) {
        context.sendMessageToAllEdges(vertex, (Value)result);
    }

    default public void updateState(Vertex vertex) {
        vertex.inactivate();
    }
}

