/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.job;

import java.util.Map;
import org.apache.hugegraph.api.job.JobAPI;
import org.apache.hugegraph.api.task.TaskAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.SchemaElement;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.IndexLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.E;

public class RebuildAPI
extends JobAPI {
    private static final String JOB_TYPE = "rebuild";

    public RebuildAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String jobType() {
        return JOB_TYPE;
    }

    public long rebuild(VertexLabel vertexLabel) {
        return this.rebuildIndex(vertexLabel);
    }

    public long rebuild(EdgeLabel edgeLabel) {
        return this.rebuildIndex(edgeLabel);
    }

    public long rebuild(IndexLabel indexLabel) {
        return this.rebuildIndex(indexLabel);
    }

    private long rebuildIndex(SchemaElement element) {
        E.checkArgument(element instanceof VertexLabel || element instanceof EdgeLabel || element instanceof IndexLabel, "Only VertexLabel, EdgeLabel and IndexLabel support rebuild, but got '%s'", element);
        String path = String.join((CharSequence)"/", this.path(), element.type());
        RestResult result = this.client.put(path, element.name(), element);
        Map task = result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }
}

