/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hg.metrics;

import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadMetrics;

public final class LoadSummary {
    private final LongAdder vertexLoaded = new LongAdder();
    private final StopWatch totalTimer = new StopWatch();
    private final LoadMetrics metrics = new LoadMetrics();

    public LoadMetrics metrics() {
        return this.metrics;
    }

    public long vertexLoaded() {
        return this.vertexLoaded.longValue();
    }

    public void plusLoaded(int count) {
        this.vertexLoaded.add(count);
    }

    public long totalTime() {
        return this.totalTimer.getTime();
    }

    public void startTimer() {
        if (!this.totalTimer.isStarted()) {
            this.totalTimer.start();
        }
    }

    public void stopTimer() {
        if (!this.totalTimer.isStopped()) {
            this.totalTimer.stop();
        }
    }

    public long loadRate() {
        long totalTime = this.totalTime();
        if (totalTime == 0L) {
            return -1L;
        }
        return this.vertexLoaded() * 1000L / totalTime;
    }
}

