/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.util;

import com.google.common.base.CharMatcher;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import org.apache.hugegraph.serializer.direct.util.HugeException;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public final class StringEncoding {
    private static final MessageDigest DIGEST;
    private static final byte[] BYTES_EMPTY;
    private static final String STRING_EMPTY = "";
    private static final int BLOCK_SIZE = 4096;
    private static final Base64.Encoder BASE64_ENCODER;
    private static final Base64.Decoder BASE64_DECODER;

    public static int writeAsciiString(byte[] array, int offset, String value) {
        E.checkArgument(CharMatcher.ascii().matchesAllOf(value), "'%s' must be ASCII string", value);
        int len = value.length();
        if (len == 0) {
            array[offset++] = -128;
            return offset;
        }
        int i = 0;
        do {
            char c = value.charAt(i);
            assert (c <= '\u007f');
            byte b = (byte)c;
            if (++i == len) {
                b = (byte)(b | 0x80);
            }
            array[offset++] = b;
        } while (i < len);
        return offset;
    }

    public static String readAsciiString(byte[] array, int offset) {
        StringBuilder sb = new StringBuilder();
        int c = 0;
        do {
            if ((c = 0xFF & array[offset++]) == 128) continue;
            sb.append((char)(c & 0x7F));
        } while ((c & 0x80) <= 0);
        return sb.toString();
    }

    public static int getAsciiByteLength(String value) {
        E.checkArgument(CharMatcher.ascii().matchesAllOf(value), "'%s' must be ASCII string", value);
        return value.isEmpty() ? 1 : value.length();
    }

    public static byte[] encode(String value) {
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes) {
        if (bytes.length == 0) {
            return STRING_EMPTY;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String decode(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return STRING_EMPTY;
        }
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String encodeBase64(byte[] bytes) {
        return BASE64_ENCODER.encodeToString(bytes);
    }

    public static byte[] decodeBase64(String value) {
        if (value.isEmpty()) {
            return BYTES_EMPTY;
        }
        return BASE64_DECODER.decode(value);
    }

    public static String sha256(String string) {
        byte[] stringBytes = StringEncoding.encode(string);
        DIGEST.reset();
        return StringEncoding.encodeBase64(DIGEST.digest(stringBytes));
    }

    public static String format(byte[] bytes) {
        return String.format("%s[0x%s]", StringEncoding.decode(bytes), Bytes.toHex(bytes));
    }

    public static UUID uuid(String value) {
        E.checkArgument(value != null, "The UUID can't be null", new Object[0]);
        try {
            if (value.contains("-") && value.length() == 36) {
                return UUID.fromString(value);
            }
            E.checkArgument(value.length() == 32, "Invalid UUID string: %s", value);
            String high = value.substring(0, 16);
            String low = value.substring(16);
            return new UUID(Long.parseUnsignedLong(high, 16), Long.parseUnsignedLong(low, 16));
        }
        catch (NumberFormatException ignored) {
            throw new IllegalArgumentException("Invalid UUID string: " + value);
        }
    }

    static {
        BYTES_EMPTY = new byte[0];
        String ALG = "SHA-256";
        try {
            DIGEST = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HugeException("Failed to load algorithm %s", (Throwable)e, "SHA-256");
        }
        BASE64_ENCODER = Base64.getEncoder();
        BASE64_DECODER = Base64.getDecoder();
    }
}

