/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.auth;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import org.apache.hugegraph.structure.auth.HugeResourceType;
import org.apache.hugegraph.util.JsonUtil;

public class HugeResource {
    public static final String ANY = "*";
    @JsonProperty(value="type")
    private HugeResourceType type = HugeResourceType.NONE;
    @JsonProperty(value="label")
    private String label = "*";
    @JsonProperty(value="properties")
    private Map<String, Object> properties;

    public HugeResource() {
    }

    public HugeResource(HugeResourceType type) {
        this(type, ANY);
    }

    public HugeResource(HugeResourceType type, String label) {
        this(type, label, null);
    }

    public HugeResource(HugeResourceType type, String label, Map<String, Object> properties) {
        this.type = type;
        this.label = label;
        this.properties = properties;
    }

    public HugeResourceType resourceType() {
        return this.type;
    }

    public String label() {
        return this.label;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HugeResource)) {
            return false;
        }
        HugeResource other = (HugeResource)object;
        return this.type == other.type && Objects.equals(this.label, other.label) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.label, this.properties});
    }

    public String toString() {
        return JsonUtil.toJson(this);
    }
}

