/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.util.E;

public class TraversersAPI
extends API {
    private static final String PATH = "graphs/%s/traversers/%s";

    public TraversersAPI(RestClient client, String graph) {
        super(client);
        this.path(PATH, graph, this.type());
    }

    @Override
    protected String type() {
        return "traversers";
    }

    public static void checkPositive(int value, String name) {
        E.checkArgument((value > 0 ? 1 : 0) != 0, (String)"%s must be > 0, but got '%s'", (Object[])new Object[]{name, value});
    }

    public static void checkDegree(long degree) {
        TraversersAPI.checkLimit(degree, "Degree");
    }

    public static void checkCapacity(long capacity) {
        TraversersAPI.checkLimit(capacity, "Capacity");
    }

    public static void checkLimit(int limit) {
        TraversersAPI.checkLimit(limit, "Limit");
    }

    public static void checkAlpha(double alpha) {
        E.checkArgument((alpha > 0.0 && alpha <= 1.0 ? 1 : 0) != 0, (String)"The alpha of rank request must be in range (0, 1], but got '%s'", (Object[])new Object[]{alpha});
    }

    public static void checkSkipDegree(long skipDegree, long degree, long capacity) {
        E.checkArgument((skipDegree >= 0L ? 1 : 0) != 0, (String)"The skipped degree must be >= 0, but got '%s'", (Object[])new Object[]{skipDegree});
        if (capacity != -1L) {
            E.checkArgument((degree != -1L && degree < capacity ? 1 : 0) != 0, (String)"The max degree must be < capacity", (Object[])new Object[0]);
            E.checkArgument((skipDegree < capacity ? 1 : 0) != 0, (String)"The skipped degree must be < capacity", (Object[])new Object[0]);
        }
        if (skipDegree > 0L) {
            E.checkArgument((degree != -1L && skipDegree >= degree ? 1 : 0) != 0, (String)"The skipped degree must be >= max degree, but got skipped degree '%s' and max degree '%s'", (Object[])new Object[]{skipDegree, degree});
        }
    }
}

