/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.util.E;

public class EdgeMapping
extends ElementMapping {
    @JsonProperty(value="source")
    private final List<String> sourceFields;
    @JsonProperty(value="unfold_source")
    private final boolean unfoldSource;
    @JsonProperty(value="target")
    private final List<String> targetFields;
    @JsonProperty(value="unfold_target")
    private final boolean unfoldTarget;

    @JsonCreator
    public EdgeMapping(@JsonProperty(value="source") List<String> sourceFields, @JsonProperty(value="unfold_source") boolean unfoldSource, @JsonProperty(value="target") List<String> targetFields, @JsonProperty(value="unfold_target") boolean unfoldTarget) {
        this.sourceFields = sourceFields;
        this.unfoldSource = unfoldSource;
        this.targetFields = targetFields;
        this.unfoldTarget = unfoldTarget;
    }

    @Override
    public ElemType type() {
        return ElemType.EDGE;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
        E.checkArgument((this.sourceFields != null && !this.sourceFields.isEmpty() ? 1 : 0) != 0, (String)"The source field of edge label '%s' can't be null or empty", (Object[])new Object[]{this.label()});
        E.checkArgument((this.targetFields != null && !this.targetFields.isEmpty() ? 1 : 0) != 0, (String)"The target field of edge label '%s' can't be null or empty", (Object[])new Object[]{this.label()});
    }

    public List<String> sourceFields() {
        return this.sourceFields;
    }

    public boolean unfoldSource() {
        return this.unfoldSource;
    }

    public List<String> targetFields() {
        return this.targetFields;
    }

    public boolean unfoldTarget() {
        return this.unfoldTarget;
    }

    public String toString() {
        return String.format("edge-mapping(label=%s)", this.label());
    }
}

