/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.hdfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.hdfs.KerberosConfig;
import org.apache.hugegraph.util.E;

public class HDFSSource
extends FileSource {
    @JsonProperty(value="core_site_path")
    private String coreSitePath;
    @JsonProperty(value="hdfs_site_path")
    private String hdfsSitePath;
    @JsonProperty(value="kerberos_config")
    private KerberosConfig kerberosConfig;

    @Override
    public SourceType type() {
        return SourceType.HDFS;
    }

    @Override
    public void check() throws IllegalArgumentException {
        super.check();
        E.checkArgument((!StringUtils.isEmpty((CharSequence)this.coreSitePath) ? 1 : 0) != 0, (String)"The core_site_path can't be empty", (Object[])new Object[0]);
        File coreSiteFile = FileUtils.getFile((String[])new String[]{Paths.get(this.coreSitePath, new String[0]).toString()});
        E.checkArgument((coreSiteFile.exists() && coreSiteFile.isFile() ? 1 : 0) != 0, (String)"The core site file '%s' is not an existing file", (Object[])new Object[]{coreSiteFile});
        if (this.hdfsSitePath != null) {
            File hdfsSiteFile = FileUtils.getFile((String[])new String[]{Paths.get(this.hdfsSitePath, new String[0]).toString()});
            E.checkArgument((hdfsSiteFile.exists() && hdfsSiteFile.isFile() ? 1 : 0) != 0, (String)"The hdfs site file '%s' is not an existing file", (Object[])new Object[]{hdfsSiteFile});
        }
        if (this.kerberosConfig != null) {
            this.kerberosConfig.check();
        }
    }

    public String coreSitePath() {
        return this.coreSitePath;
    }

    public String hdfsSitePath() {
        return this.hdfsSitePath;
    }

    public KerberosConfig kerberosConfig() {
        return this.kerberosConfig;
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", new Object[]{this.type(), this.path()});
    }
}

