/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source.hdfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.loader.constant.Checkable;
import org.apache.hugegraph.util.E;

public class KerberosConfig
implements Checkable {
    @JsonProperty(value="enable")
    private boolean enable;
    @JsonProperty(value="krb5_conf")
    private String krb5Conf;
    @JsonProperty(value="principal")
    private String principal;
    @JsonProperty(value="keytab")
    private String keyTab;

    @Override
    public void check() throws IllegalArgumentException {
        if (this.enable) {
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.krb5Conf) ? 1 : 0) != 0, (String)"The krb5_conf can't be empty", (Object[])new Object[0]);
            File krb5ConfFile = FileUtils.getFile((String[])new String[]{Paths.get(this.krb5Conf, new String[0]).toString()});
            E.checkArgument((krb5ConfFile.exists() && krb5ConfFile.isFile() ? 1 : 0) != 0, (String)"The krb5 conf file '%s' is not an existing file", (Object[])new Object[]{krb5ConfFile});
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.principal) ? 1 : 0) != 0, (String)"The principal can't be empty", (Object[])new Object[0]);
            E.checkArgument((!StringUtils.isEmpty((CharSequence)this.keyTab) ? 1 : 0) != 0, (String)"The keytab can't be empty", (Object[])new Object[0]);
            File keyTabFile = FileUtils.getFile((String[])new String[]{Paths.get(this.keyTab, new String[0]).toString()});
            E.checkArgument((keyTabFile.exists() && keyTabFile.isFile() ? 1 : 0) != 0, (String)"The key tab file '%s' is not an existing file", (Object[])new Object[]{keyTabFile});
        }
    }

    public boolean enable() {
        return this.enable;
    }

    public String krb5Conf() {
        return this.krb5Conf;
    }

    public String principal() {
        return this.principal;
    }

    public String keyTab() {
        return this.keyTab;
    }
}

