/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.meta;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.reflect.getter.NullGetter;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.ShortCircuiter;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public abstract class PropertyFinder<T> {
    public static PropertyFinderTransformer IDENTITY_TRANSFORMER = new PropertyFinderTransformer(){

        @Override
        public <T> PropertyFinder<T> apply(PropertyFinder<T> propertyFinder) {
            return propertyFinder;
        }

        public String toString() {
            return "IDENTITY_TRANSFORMER";
        }
    };

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, TypeAffinityScorer typeAffinity, PropertyFilter propertyFilter, ShortCircuiter shortCircuiter) {
        MatchingProperties matchingProperties = new MatchingProperties(new DefaultPropertyFinderProbe(propertyNameMatcher));
        this.lookForProperties(propertyNameMatcher, properties, matchingProperties, PropertyMatchingScore.newInstance(), true, IDENTITY_TRANSFORMER, typeAffinity, propertyFilter, shortCircuiter);
        return matchingProperties.selectBestMatch();
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, TypeAffinity typeAffinity, PropertyFilter propertyFilter) {
        return this.findProperty(propertyNameMatcher, properties, this.toTypeAffinityScorer(typeAffinity), propertyFilter);
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, TypeAffinityScorer typeAffinity, PropertyFilter propertyFilter) {
        return this.findProperty(propertyNameMatcher, properties, typeAffinity, (PropertyFinderProbe)new DefaultPropertyFinderProbe(propertyNameMatcher), propertyFilter);
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, TypeAffinity typeAffinity, PropertyFinderProbe propertyFinderProbe, PropertyFilter propertyFilter) {
        return this.findProperty(propertyNameMatcher, properties, this.toTypeAffinityScorer(typeAffinity), propertyFinderProbe, propertyFilter);
    }

    public final <E> PropertyMeta<T, E> findProperty(PropertyNameMatcher propertyNameMatcher, Object[] properties, TypeAffinityScorer typeAffinity, PropertyFinderProbe propertyFinderProbe, PropertyFilter propertyFilter) {
        MatchingProperties matchingProperties = new MatchingProperties(propertyFinderProbe);
        this.lookForProperties(propertyNameMatcher, properties, matchingProperties, PropertyMatchingScore.newInstance(), true, IDENTITY_TRANSFORMER, typeAffinity, propertyFilter);
        return matchingProperties.selectBestMatch();
    }

    private TypeAffinityScorer toTypeAffinityScorer(TypeAffinity typeAffinity) {
        return new TypeAffinityScorer(typeAffinity);
    }

    public final void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinderTransformer propertyFinderTransformer, TypeAffinityScorer typeAffinityScorer, PropertyFilter propertyFilter) {
        this.lookForProperties(propertyNameMatcher, properties, matchingProperties, score, allowSelfReference, propertyFinderTransformer, typeAffinityScorer, propertyFilter, new ShortCircuiter());
    }

    public abstract void lookForProperties(PropertyNameMatcher var1, Object[] var2, FoundProperty<T> var3, PropertyMatchingScore var4, boolean var5, PropertyFinderTransformer var6, TypeAffinityScorer var7, PropertyFilter var8, ShortCircuiter var9);

    public abstract List<InstantiatorDefinition> getEligibleInstantiatorDefinitions();

    public abstract PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> var1);

    public abstract PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> var1);

    public abstract Type getOwnerType();

    @Deprecated
    public boolean selfScoreFullName() {
        return false;
    }

    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (prop.isSubProperty()) {
            SubPropertyMeta subPropertyMeta = (SubPropertyMeta)prop;
            PropertyMeta ownerProperty = subPropertyMeta.getOwnerProperty();
            this.manualMatch(ownerProperty);
            PropertyFinder subPropertyFinder = this.getOrCreateSubPropertyFinder(subPropertyMeta);
            subPropertyFinder.manualMatch(subPropertyMeta.getSubProperty());
        }
    }

    public static final class PropertyFilter {
        private final Predicate<PropertyMeta<?, ?>> propertyMetaPredicate;
        private final Predicate<PropertyMeta<?, ?>> pathMetaPredicate;
        private static final PropertyFilter TRUE_FILTER = new PropertyFilter((Predicate<PropertyMeta<?, ?>>)ConstantPredicate.truePredicate(), (Predicate<PropertyMeta<?, ?>>)ConstantPredicate.truePredicate());

        public PropertyFilter(Predicate<PropertyMeta<?, ?>> predicate) {
            this.propertyMetaPredicate = predicate;
            this.pathMetaPredicate = predicate;
        }

        public PropertyFilter(Predicate<PropertyMeta<?, ?>> propertyMetaPredicate, Predicate<PropertyMeta<?, ?>> pathMetaPredicate) {
            this.propertyMetaPredicate = propertyMetaPredicate;
            this.pathMetaPredicate = pathMetaPredicate;
        }

        public static PropertyFilter trueFilter() {
            return TRUE_FILTER;
        }

        public boolean testProperty(PropertyMeta<?, ?> propertyMeta) {
            return this.propertyMetaPredicate.test(propertyMeta);
        }

        public boolean testPath(PropertyMeta<?, ?> propertyMeta) {
            return this.pathMetaPredicate.test(propertyMeta);
        }
    }

    public static class DefaultPropertyFinderProbe
    implements PropertyFinderProbe {
        private static final boolean DEBUG = Boolean.getBoolean("org.simpleflatmapper.probe.propertyFinder");
        private final PropertyNameMatcher propertyNameMatcher;

        public DefaultPropertyFinderProbe(PropertyNameMatcher propertyNameMatcher) {
            this.propertyNameMatcher = propertyNameMatcher;
        }

        @Override
        public void found(PropertyMeta propertyMeta, PropertyMatchingScore score) {
            if (DEBUG) {
                System.out.println("PropertyFinder for '" + this.propertyNameMatcher + "' - found " + score + " " + propertyMeta.getPath());
            }
        }

        @Override
        public void select(PropertyMeta propertyMeta) {
            if (DEBUG) {
                System.out.println("PropertyFinder for '" + this.propertyNameMatcher + "' - select " + propertyMeta.getPath());
            }
        }
    }

    public static interface PropertyFinderProbe {
        public void found(PropertyMeta var1, PropertyMatchingScore var2);

        public void select(PropertyMeta var1);
    }

    public static interface PropertyFinderTransformer {
        public <T> PropertyFinder<T> apply(PropertyFinder<T> var1);
    }

    public static interface FoundProperty<T> {
        public <P extends PropertyMeta<T, ?>> void found(P var1, Runnable var2, PropertyMatchingScore var3, TypeAffinityScorer var4);
    }

    public static class TypeAffinityScorer {
        private Class<?>[] affinities;

        public TypeAffinityScorer(TypeAffinity typeAffinity) {
            this.affinities = typeAffinity == null || typeAffinity.getAffinities() == null ? new Class[0] : typeAffinity.getAffinities();
        }

        public TypeAffinityScorer(Class<?>[] affinities) {
            this.affinities = affinities;
        }

        public int score(Type type) {
            for (int i = 0; i < this.affinities.length; ++i) {
                if (!TypeHelper.isAssignable((Type)type, this.affinities[i])) continue;
                return this.affinities.length - i;
            }
            return -1;
        }
    }

    public static class MatchedProperty<T, P extends PropertyMeta<T, ?>>
    implements Comparable<MatchedProperty<T, ?>> {
        private final P propertyMeta;
        private final Runnable selectionCallback;
        private final PropertyMatchingScore score;
        private final int typeAffinityScore;

        public MatchedProperty(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, int typeAffinityScore) {
            this.propertyMeta = propertyMeta;
            this.selectionCallback = selectionCallback;
            this.score = score;
            this.typeAffinityScore = typeAffinityScore;
        }

        public PropertyMatchingScore getScore() {
            return this.score;
        }

        public P getPropertyMeta() {
            return this.propertyMeta;
        }

        @Override
        public int compareTo(MatchedProperty<T, ?> o) {
            int i = this.score.compareTo(o.score);
            if (i == 0) {
                int n = this.typeAffinityScore > o.typeAffinityScore ? -1 : (i = this.typeAffinityScore == o.typeAffinityScore ? 0 : 1);
                if (i == 0) {
                    return this.compare((PropertyMeta<?, ?>)this.propertyMeta, (PropertyMeta<?, ?>)o.propertyMeta);
                }
                return i;
            }
            return i;
        }

        private int compare(PropertyMeta<?, ?> p1, PropertyMeta<?, ?> p2) {
            if (p1.isConstructorProperty()) {
                if (!p2.isConstructorProperty()) {
                    return -1;
                }
            } else {
                if (p2.isConstructorProperty()) {
                    return 1;
                }
                if (!p1.isSelf()) {
                    if (p2.isSelf()) {
                        return -1;
                    }
                } else {
                    if (!p2.isSelf()) {
                        return 1;
                    }
                    if (!p1.isSubProperty()) {
                        if (p2.isSubProperty()) {
                            return -1;
                        }
                    } else if (!p2.isSubProperty()) {
                        return 1;
                    }
                }
            }
            return this.getterSetterCompare(p1, p2);
        }

        private int getterSetterCompare(PropertyMeta<?, ?> p1, PropertyMeta<?, ?> p2) {
            return this.nbGetterSetter(p2) - this.nbGetterSetter(p1);
        }

        private int nbGetterSetter(PropertyMeta<?, ?> p) {
            int c = 0;
            try {
                if (!NullGetter.isNull(p.getGetter())) {
                    ++c;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                if (!NullSetter.isNull(p.getSetter())) {
                    ++c;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return c;
        }

        public void select() {
            if (this.selectionCallback != null) {
                this.selectionCallback.run();
            }
        }

        public String toString() {
            return "MatchedProperty{propertyMeta=" + ((PropertyMeta)this.propertyMeta).getPath() + ", score=" + this.score + ":" + this.nbGetterSetter((PropertyMeta<?, ?>)this.propertyMeta) + ", getter=" + ((PropertyMeta)this.propertyMeta).getGetter() + ", setter=" + ((PropertyMeta)this.propertyMeta).getSetter() + '}';
        }
    }

    protected static class MatchingProperties<T>
    implements FoundProperty<T> {
        private final List<MatchedProperty<T, ?>> matchedProperties = new ArrayList();
        private final PropertyFinderProbe propertyFinderProbe;

        public MatchingProperties(PropertyFinderProbe propertyFinderProbe) {
            this.propertyFinderProbe = propertyFinderProbe;
        }

        @Override
        public <P extends PropertyMeta<T, ?>> void found(P propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, TypeAffinityScorer typeAffinityScorer) {
            this.propertyFinderProbe.found(propertyMeta, score);
            this.matchedProperties.add(new MatchedProperty(propertyMeta, selectionCallback, score, propertyMeta.typeAffinityScore(typeAffinityScorer)));
        }

        public PropertyMeta<T, ?> selectBestMatch() {
            if (this.matchedProperties.isEmpty()) {
                return null;
            }
            Iterator<MatchedProperty<T, ?>> iterator = this.matchedProperties.iterator();
            MatchedProperty<T, ?> highestCore = iterator.next();
            while (iterator.hasNext()) {
                MatchedProperty<T, ?> next = iterator.next();
                if (next.compareTo(highestCore) >= 0) continue;
                highestCore = next;
            }
            highestCore.select();
            this.propertyFinderProbe.select(((MatchedProperty)highestCore).propertyMeta);
            return ((MatchedProperty)highestCore).propertyMeta;
        }
    }
}

