/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class SerialReplicationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(SerialReplicationChecker.class);
    public static final String REPLICATION_SERIALLY_WAITING_KEY = "hbase.serial.replication.waiting.ms";
    public static final long REPLICATION_SERIALLY_WAITING_DEFAULT = 10000L;
    private final String peerId;
    private final ReplicationQueueStorage storage;
    private final Connection conn;
    private final long waitTimeMs;
    private final LoadingCache<String, MutableLong> pushed = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, MutableLong>(){

        public MutableLong load(String key) throws Exception {
            return new MutableLong(-1L);
        }
    });
    private final Cache<String, Long> canPushUnder = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();

    public SerialReplicationChecker(Configuration conf, ReplicationSource source) {
        this.peerId = source.getPeerId();
        this.storage = source.getQueueStorage();
        this.conn = source.getServer().getConnection();
        this.waitTimeMs = conf.getLong(REPLICATION_SERIALLY_WAITING_KEY, 10000L);
    }

    private boolean isRangeFinished(long endBarrier, String encodedRegionName) throws IOException {
        long pushedSeqId;
        try {
            pushedSeqId = this.storage.getLastSequenceId(encodedRegionName, this.peerId);
        }
        catch (ReplicationException e) {
            throw new IOException("Failed to get pushed sequence id for " + encodedRegionName + ", peer " + this.peerId, e);
        }
        return pushedSeqId >= endBarrier - 1L;
    }

    private boolean isParentFinished(byte[] regionName) throws IOException {
        long[] barriers = MetaTableAccessor.getReplicationBarrier((Connection)this.conn, (byte[])regionName);
        if (barriers.length == 0) {
            return true;
        }
        return this.isRangeFinished(barriers[barriers.length - 1], RegionInfo.encodeRegionName((byte[])regionName));
    }

    private boolean isLastRangeAndOpening(MetaTableAccessor.ReplicationBarrierResult barrierResult, int index) {
        return index == barrierResult.getBarriers().length && barrierResult.getState() == RegionState.State.OPENING;
    }

    private void recordCanPush(String encodedNameAsString, long seqId, long[] barriers, int index) {
        if (barriers.length > index) {
            this.canPushUnder.put((Object)encodedNameAsString, (Object)barriers[index]);
        }
        ((MutableLong)this.pushed.getUnchecked((Object)encodedNameAsString)).setValue(seqId);
    }

    private boolean canPush(WAL.Entry entry, byte[] row) throws IOException {
        String encodedNameAsString = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
        long seqId = entry.getKey().getSequenceId();
        MetaTableAccessor.ReplicationBarrierResult barrierResult = MetaTableAccessor.getReplicationBarrierResult((Connection)this.conn, (TableName)entry.getKey().getTableName(), (byte[])row, (byte[])entry.getKey().getEncodedRegionName());
        LOG.debug("Replication barrier for {}: {}", (Object)entry, (Object)barrierResult);
        long[] barriers = barrierResult.getBarriers();
        int index = Arrays.binarySearch(barriers, seqId);
        if (index == -1) {
            LOG.debug("{} is before the first barrier, pass", (Object)entry);
            ((MutableLong)this.pushed.getUnchecked((Object)encodedNameAsString)).setValue(seqId);
            return true;
        }
        index = index < 0 ? -index - 1 : ++index;
        if (index == 1) {
            for (byte[] regionName : barrierResult.getParentRegionNames()) {
                if (this.isParentFinished(regionName)) continue;
                LOG.debug("Parent {} has not been finished yet for entry {}, give up", (Object)Bytes.toStringBinary((byte[])regionName), (Object)entry);
                return false;
            }
            if (this.isLastRangeAndOpening(barrierResult, index)) {
                LOG.debug("{} is in the last range and the region is opening, give up", (Object)entry);
                return false;
            }
            LOG.debug("{} is in the first range, pass", (Object)entry);
            this.recordCanPush(encodedNameAsString, seqId, barriers, 1);
            return true;
        }
        if (!this.isRangeFinished(barriers[index - 1], encodedNameAsString)) {
            LOG.debug("Previous range for {} has not been finished yet, give up", (Object)entry);
            return false;
        }
        if (this.isLastRangeAndOpening(barrierResult, index)) {
            LOG.debug("{} is in the last range and the region is opening, give up", (Object)entry);
            return false;
        }
        LOG.debug("The previous range for {} has been finished, pass", (Object)entry);
        this.recordCanPush(encodedNameAsString, seqId, barriers, index);
        return true;
    }

    public boolean canPush(WAL.Entry entry, Cell firstCellInEdit) throws IOException {
        MutableLong previousPushedSeqId;
        String encodedNameAsString = Bytes.toString((byte[])entry.getKey().getEncodedRegionName());
        long seqId = entry.getKey().getSequenceId();
        Long canReplicateUnderSeqId = (Long)this.canPushUnder.getIfPresent((Object)encodedNameAsString);
        if (canReplicateUnderSeqId != null) {
            if (seqId < canReplicateUnderSeqId) {
                LOG.trace("{} is before the end barrier {}, pass", (Object)entry, (Object)canReplicateUnderSeqId);
                return true;
            }
            LOG.debug("{} is beyond the previous end barrier {}, remove from cache", (Object)entry, (Object)canReplicateUnderSeqId);
            this.canPushUnder.invalidate((Object)encodedNameAsString);
        }
        if (seqId == (previousPushedSeqId = (MutableLong)this.pushed.getUnchecked((Object)encodedNameAsString)).longValue() + 1L) {
            LOG.trace("The sequence id for {} is continuous, pass", (Object)entry);
            previousPushedSeqId.increment();
            return true;
        }
        return this.canPush(entry, CellUtil.cloneRow((Cell)firstCellInEdit));
    }

    public void waitUntilCanPush(WAL.Entry entry, Cell firstCellInEdit) throws IOException, InterruptedException {
        byte[] row = CellUtil.cloneRow((Cell)firstCellInEdit);
        while (!this.canPush(entry, row)) {
            LOG.debug("Can not push {}, wait", (Object)entry);
            Thread.sleep(this.waitTimeMs);
        }
    }
}

