/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LossyCounting {
    private static final Logger LOG = LoggerFactory.getLogger(LossyCounting.class);
    private long bucketSize;
    private int currentTerm;
    private double errorRate;
    private Map<String, Integer> data;
    private long totalDataCount;
    private String name;
    private LossyCountingListener listener;

    public LossyCounting(double errorRate, String name, LossyCountingListener listener) {
        this.errorRate = errorRate;
        this.name = name;
        if (errorRate < 0.0 || errorRate > 1.0) {
            throw new IllegalArgumentException(" Lossy Counting error rate should be within range [0,1]");
        }
        this.bucketSize = (long)Math.ceil(1.0 / errorRate);
        this.currentTerm = 1;
        this.totalDataCount = 0L;
        this.data = new ConcurrentHashMap<String, Integer>();
        this.listener = listener;
        this.calculateCurrentTerm();
    }

    public LossyCounting(String name, LossyCountingListener listener) {
        this(HBaseConfiguration.create().getDouble("hbase.util.default.lossycounting.errorrate", 0.02), name, listener);
    }

    private void addByOne(String key) {
        this.data.put(key, this.data.getOrDefault(key, this.currentTerm != 0 ? this.currentTerm - 1 : 0) + 1);
        ++this.totalDataCount;
        this.calculateCurrentTerm();
    }

    public void add(String key) {
        this.addByOne(key);
        if (this.totalDataCount % this.bucketSize == 0L) {
            this.sweep();
        }
    }

    private void sweep() {
        for (Map.Entry<String, Integer> entry : this.data.entrySet()) {
            if (entry.getValue() >= this.currentTerm) continue;
            String metric = entry.getKey();
            this.data.remove(metric);
            if (this.listener == null) continue;
            this.listener.sweep(metric);
        }
    }

    private void calculateCurrentTerm() {
        this.currentTerm = (int)Math.ceil(1.0 * (double)this.totalDataCount / (double)this.bucketSize);
    }

    public long getBucketSize() {
        return this.bucketSize;
    }

    public long getDataSize() {
        return this.data.size();
    }

    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    public Set<String> getElements() {
        return this.data.keySet();
    }

    public long getCurrentTerm() {
        return this.currentTerm;
    }

    public static interface LossyCountingListener {
        public void sweep(String var1);
    }
}

