/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.hugegraph.util.E;

public abstract class Directory {
    private final String directory;

    public Directory(String directory) {
        E.checkArgument((directory != null && !directory.isEmpty() ? 1 : 0) != 0, (String)"Directory can't be null or empty", (Object[])new Object[0]);
        this.directory = directory;
    }

    public String directory() {
        return this.directory;
    }

    public abstract List<String> files();

    public abstract String suffix(boolean var1);

    public abstract void ensureDirectoryExist(boolean var1);

    public abstract void removeDirectory();

    public abstract InputStream inputStream(String var1);

    public abstract OutputStream outputStream(String var1, boolean var2, boolean var3);

    public static void closeAndIgnoreException(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

