/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.manager;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.base.LocalDirectory;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.cmd.SubCommands;
import org.apache.hugegraph.formatter.Formatter;
import org.apache.hugegraph.manager.BackupManager;
import org.apache.hugegraph.structure.JsonGraph;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;

public class DumpGraphManager
extends BackupManager {
    private static final byte[] EOF = "\n".getBytes();
    private final JsonGraph graph = new JsonGraph();
    private Formatter dumpFormatter;

    public DumpGraphManager(ToolClient.ConnectionInfo info) {
        this(info, "JsonFormatter");
    }

    public DumpGraphManager(ToolClient.ConnectionInfo info, String formatter) {
        super(info);
        this.dumpFormatter = Formatter.loadFormatter(formatter);
    }

    public void dumpFormatter(String formatter) {
        this.dumpFormatter = Formatter.loadFormatter(formatter);
    }

    public void init(SubCommands.DumpGraph dump) {
        assert (dump.retry() > 0);
        this.retry(dump.retry());
        LocalDirectory.ensureDirectoryExist(dump.logDir());
        this.logDir(dump.logDir());
        this.directory(dump.directory(), dump.hdfsConf());
        this.removeShardsFilesIfExists();
        this.ensureDirectoryExist(true);
        this.splitSize(dump.splitSize());
    }

    public void dump() {
        this.startTimer();
        try {
            this.backupVertices();
            this.backupEdges();
            for (String table : this.graph.tables()) {
                this.submit(() -> this.dump(table, this.graph.table(table).values()));
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.shutdown(this.type());
        }
        this.printSummary("dump graph");
    }

    private void dump(String file, Collection<JsonGraph.JsonVertex> vertices) {
        try (OutputStream os = this.outputStream(file, false);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            for (JsonGraph.JsonVertex vertex : vertices) {
                String content = this.dumpFormatter.dump(vertex);
                bos.write(content.getBytes("UTF-8"));
                bos.write(EOF);
            }
        }
        catch (Throwable e) {
            Printer.print("Failed to write vertex: %s", e);
        }
    }

    @Override
    protected long write(String file, HugeType type, List<?> list, boolean compress) {
        switch (type) {
            case VERTEX: {
                for (Object vertex : list) {
                    this.graph.put((Vertex)vertex);
                }
                break;
            }
            case EDGE: {
                for (Object edge : list) {
                    this.graph.put((Edge)edge);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid type " + type));
            }
        }
        return list.size();
    }
}

